/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.bean.config.MaskAction;
import com.payne.reader.bean.config.MaskId;
import com.payne.reader.bean.config.MaskTarget;
import com.payne.reader.bean.config.MemBank;
import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public final class MaskConfig {
    private byte[] maskInfo;

    MaskConfig(Builder builder) {
        int valueLen = builder.maskValue.length;
        this.maskInfo = new byte[7 + valueLen];
        this.maskInfo[0] = builder.function;
        this.maskInfo[1] = builder.target;
        this.maskInfo[2] = builder.action;
        this.maskInfo[3] = builder.memBank;
        this.maskInfo[4] = builder.maskBitStartAddress;
        this.maskInfo[5] = builder.maskBitLength;
        System.arraycopy(builder.maskValue, 0, this.maskInfo, 6, valueLen);
        this.maskInfo[this.maskInfo.length - 1] = builder.truncate;
    }

    public byte[] getMaskInfo() {
        return this.maskInfo;
    }

    public static class Builder {
        private byte function = MaskId.TAG_MASK_NO4.getValue();
        private byte target = MaskTarget.Inventoried_S0.getValue();
        private byte action = MaskAction.Action0.getValue();
        private byte memBank = MemBank.EPC.getValue();
        private byte maskBitStartAddress = 0;
        private byte maskBitLength = 0;
        private byte[] maskValue = null;
        private byte truncate = 0;

        public Builder setFunction(MaskId function) {
            Objects.requireNonNull(function);
            this.function = function.getValue();
            return this;
        }

        public Builder setTarget(MaskTarget target) {
            Objects.requireNonNull(target);
            this.target = target.getValue();
            return this;
        }

        public Builder setAction(MaskAction action) {
            Objects.requireNonNull(action);
            this.action = action.getValue();
            return this;
        }

        public Builder setMemBank(MemBank memBank) {
            Objects.requireNonNull(memBank);
            this.memBank = memBank.getValue();
            return this;
        }

        public Builder setMaskBitStartAddress(byte maskBitStartAddress) {
            this.maskBitStartAddress = maskBitStartAddress;
            return this;
        }

        public Builder setMaskBitLength(byte maskBitLength) {
            this.maskBitLength = maskBitLength;
            return this;
        }

        public Builder setMaskValue(byte[] maskValue) {
            Objects.requireNonNull(maskValue);
            this.maskValue = maskValue;
            return this;
        }

        public Builder setMaskValue(String hexMaskValue) {
            Objects.requireNonNull(hexMaskValue);
            if (CheckUtils.isNotHexString(hexMaskValue)) {
                throw new InvalidParameterException("hexMaskValue must be a hexadecimal string!");
            }
            byte[] data = ArrayUtils.hexStringToBytes(hexMaskValue);
            return this.setMaskValue(data);
        }

        public Builder setTruncate(byte truncate) {
            this.truncate = truncate;
            return this;
        }

        public MaskConfig build() {
            if (this.maskValue == null) {
                this.maskValue = new byte[this.maskBitLength >>> 3];
            } else if (this.maskBitLength == 0) {
                int len = this.maskValue.length;
                this.maskBitLength = (byte)(len << 3);
            }
            return new MaskConfig(this);
        }
    }
}

