/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.bean.config.LockMemBank;
import com.payne.reader.bean.config.LockType;
import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public final class LockConfig {
    private byte[] lockInfo;

    LockConfig(Builder builder) {
        int pwLen = builder.passwords.length;
        this.lockInfo = new byte[pwLen + 2];
        System.arraycopy(builder.passwords, 0, this.lockInfo, 0, pwLen);
        this.lockInfo[pwLen] = builder.memBank;
        this.lockInfo[pwLen + 1] = builder.lockType;
    }

    public byte[] getLockInfo() {
        return this.lockInfo;
    }

    public static class Builder {
        private byte[] passwords = null;
        private byte memBank = LockMemBank.EPC_MEMORY.getValue();
        private byte lockType = LockType.OPEN.getValue();

        public Builder setPasswords(byte[] passwords) {
            Objects.requireNonNull(passwords);
            int demandLength = 4;
            if (passwords.length < demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, src.length);
                for (int i = src.length; i < passwords.length; ++i) {
                    passwords[i] = -1;
                }
            } else if (passwords.length > demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, passwords.length);
            }
            this.passwords = passwords;
            return this;
        }

        public Builder setPasswords(String hexPassword) {
            Objects.requireNonNull(hexPassword);
            if (CheckUtils.isNotHexString(hexPassword)) {
                throw new InvalidParameterException("hexPassword must be a hexadecimal string!");
            }
            byte[] password = ArrayUtils.hexStringToBytes(hexPassword);
            return this.setPasswords(password);
        }

        public Builder setMemBank(LockMemBank memBank) {
            Objects.requireNonNull(memBank);
            this.memBank = memBank.getValue();
            return this;
        }

        public Builder setLockType(LockType lockType) {
            Objects.requireNonNull(lockType);
            this.lockType = lockType.getValue();
            return this;
        }

        public LockConfig build() {
            if (this.passwords == null) {
                byte[] passwords = new byte[]{-1, -1, -1, -1};
                this.setPasswords(passwords);
            }
            return new LockConfig(this);
        }
    }
}

