/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public final class KillConfig {
    private byte[] killInfo;

    KillConfig(Builder builder) {
        int pwLen = builder.passwords.length;
        this.killInfo = new byte[pwLen];
        System.arraycopy(builder.passwords, 0, this.killInfo, 0, pwLen);
    }

    public byte[] getKillInfo() {
        return this.killInfo;
    }

    public static class Builder {
        private byte[] passwords = null;

        public Builder setPasswords(byte[] passwords) {
            Objects.requireNonNull(passwords);
            int demandLength = 4;
            if (passwords.length < demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, src.length);
                for (int i = src.length; i < passwords.length; ++i) {
                    passwords[i] = -1;
                }
            } else if (passwords.length > demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, passwords.length);
            }
            this.passwords = passwords;
            return this;
        }

        public Builder setPasswords(String hexPassword) {
            Objects.requireNonNull(hexPassword);
            if (CheckUtils.isNotHexString(hexPassword)) {
                throw new InvalidParameterException("hexPassword must be a hexadecimal string!");
            }
            byte[] password = ArrayUtils.hexStringToBytes(hexPassword);
            return this.setPasswords(password);
        }

        public KillConfig build() {
            if (this.passwords == null) {
                byte[] passwords = new byte[]{-1, -1, -1, -1};
                this.setPasswords(passwords);
            }
            return new KillConfig(this);
        }
    }
}

