/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.base.BaseFastSwitchAntennaInventory;
import com.payne.reader.base.BaseInventory;
import com.payne.reader.base.Consumer;
import com.payne.reader.bean.config.AntennaCount;
import com.payne.reader.bean.receive.InventoryFailure;
import com.payne.reader.bean.receive.InventoryTag;
import com.payne.reader.bean.receive.InventoryTagEnd;
import com.payne.reader.bean.send.BufferInventory;
import com.payne.reader.bean.send.CustomSessionTargetInventory;
import com.payne.reader.bean.send.FastSwitchEightAntennaInventory;
import com.payne.reader.bean.send.FastSwitchFourAntennaInventory;
import com.payne.reader.bean.send.FastSwitchSingleAntennaInventory;
import com.payne.reader.bean.send.FastSwitchSixteenAntennaInventory;
import java.security.InvalidParameterException;
import java.util.Objects;

public class InventoryConfig {
    private byte cmd;
    private byte[] inventoryParams;
    private byte[] highEightAntennaInventoryParams;
    private boolean isEnablePhase;
    private AntennaCount antennaCount;
    private Consumer<InventoryTag> onSuccess;
    private Consumer<InventoryTagEnd> onSuccessEnd;
    private Consumer<InventoryFailure> onFailure;

    private InventoryConfig(Builder builder) {
        this.cmd = builder.cmd;
        this.inventoryParams = builder.inventoryParams;
        this.highEightAntennaInventoryParams = builder.highEightAntennaInventoryParams;
        this.isEnablePhase = builder.isEnablePhase;
        this.antennaCount = builder.antennaCount;
        this.onSuccess = builder.onSuccess;
        this.onSuccessEnd = builder.onSuccessEnd;
        this.onFailure = builder.onFailure;
    }

    public byte getCmd() {
        return this.cmd;
    }

    public byte[] getInventoryParams() {
        return this.inventoryParams;
    }

    public byte[] getHighEightAntennaInventoryParams() {
        return this.highEightAntennaInventoryParams;
    }

    public boolean isEnablePhase() {
        return this.isEnablePhase;
    }

    public boolean checkAntennaCount(AntennaCount count) {
        if (this.cmd == -118) {
            return this.antennaCount == count;
        }
        return true;
    }

    public Consumer<InventoryTag> getOnSuccess() {
        return this.onSuccess;
    }

    public Consumer<InventoryTagEnd> getOnSuccessEnd() {
        return this.onSuccessEnd;
    }

    public Consumer<InventoryFailure> getOnFailure() {
        return this.onFailure;
    }

    public static class Builder {
        private byte cmd = 0;
        private byte[] inventoryParams = null;
        private byte[] highEightAntennaInventoryParams = null;
        private boolean isEnablePhase = false;
        private AntennaCount antennaCount = AntennaCount.SINGLE_CHANNEL;
        private Consumer<InventoryTag> onSuccess = null;
        private Consumer<InventoryTagEnd> onSuccessEnd = null;
        private Consumer<InventoryFailure> onFailure = null;

        public Builder setInventory(BaseInventory baseInventory) {
            Objects.requireNonNull(baseInventory);
            if (baseInventory instanceof BufferInventory) {
                BufferInventory inventory = (BufferInventory)baseInventory;
                this.setInventory(inventory);
            } else if (baseInventory instanceof CustomSessionTargetInventory) {
                CustomSessionTargetInventory inventory = (CustomSessionTargetInventory)baseInventory;
                this.setInventory(inventory);
            } else if (baseInventory instanceof FastSwitchSingleAntennaInventory) {
                FastSwitchSingleAntennaInventory inventory = (FastSwitchSingleAntennaInventory)baseInventory;
                this.setInventory(inventory);
            } else if (baseInventory instanceof FastSwitchFourAntennaInventory) {
                FastSwitchFourAntennaInventory inventory = (FastSwitchFourAntennaInventory)baseInventory;
                this.setInventory(inventory);
            } else if (baseInventory instanceof FastSwitchEightAntennaInventory) {
                FastSwitchEightAntennaInventory inventory = (FastSwitchEightAntennaInventory)baseInventory;
                this.setInventory(inventory);
            } else if (baseInventory instanceof FastSwitchSixteenAntennaInventory) {
                FastSwitchSixteenAntennaInventory inventory = (FastSwitchSixteenAntennaInventory)baseInventory;
                this.setInventory(inventory);
            } else {
                throw new InvalidParameterException();
            }
            return this;
        }

        public Builder setInventory(BufferInventory inventory) {
            Objects.requireNonNull(inventory);
            try {
                this.cmd = (byte)-128;
                this.isEnablePhase = inventory.enablePhase();
                this.inventoryParams = inventory.getInventoryParams();
                this.highEightAntennaInventoryParams = inventory.getHighEightAntennaInventoryParams();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }

        public Builder setInventory(CustomSessionTargetInventory inventory) {
            Objects.requireNonNull(inventory);
            try {
                this.cmd = (byte)-117;
                this.isEnablePhase = inventory.enablePhase();
                this.inventoryParams = inventory.getInventoryParams();
                this.highEightAntennaInventoryParams = inventory.getHighEightAntennaInventoryParams();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }

        public Builder setInventory(FastSwitchSingleAntennaInventory inventory) {
            this.antennaCount = AntennaCount.SINGLE_CHANNEL;
            return this.configInventory(inventory);
        }

        public Builder setInventory(FastSwitchFourAntennaInventory inventory) {
            this.antennaCount = AntennaCount.FOUR_CHANNELS;
            return this.configInventory(inventory);
        }

        public Builder setInventory(FastSwitchEightAntennaInventory inventory) {
            this.antennaCount = AntennaCount.EIGHT_CHANNELS;
            return this.configInventory(inventory);
        }

        public Builder setInventory(FastSwitchSixteenAntennaInventory inventory) {
            this.antennaCount = AntennaCount.SIXTEEN_CHANNELS;
            return this.configInventory(inventory);
        }

        private Builder configInventory(BaseFastSwitchAntennaInventory inventory) {
            Objects.requireNonNull(inventory);
            try {
                this.cmd = (byte)-118;
                this.isEnablePhase = inventory.enablePhase();
                this.inventoryParams = inventory.getInventoryParams();
                this.highEightAntennaInventoryParams = inventory.getHighEightAntennaInventoryParams();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }

        public Builder setOnInventoryTagSuccess(Consumer<InventoryTag> onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        public Builder setOnInventoryTagEndSuccess(Consumer<InventoryTagEnd> onSuccess) {
            this.onSuccessEnd = onSuccess;
            return this;
        }

        public Builder setOnFailure(Consumer<InventoryFailure> onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public InventoryConfig build() {
            if (this.onFailure == null) {
                throw new InvalidParameterException("Unimplemented inventory failure callback");
            }
            if (this.inventoryParams == null) {
                this.setInventory(new CustomSessionTargetInventory.Builder().build());
            }
            return new InventoryConfig(this);
        }
    }
}

