/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public final class Identifier {
    private byte[] identifiers;

    Identifier(Builder builder) {
        this.identifiers = builder.identifiers;
    }

    public byte[] getIdentifiers() {
        return this.identifiers;
    }

    public static class Builder {
        private byte[] identifiers = null;

        public Builder setIdentifiers(byte[] identifiers) {
            Objects.requireNonNull(identifiers);
            int demandLength = 12;
            if (identifiers.length < demandLength) {
                byte[] src = identifiers;
                identifiers = new byte[demandLength];
                System.arraycopy(src, 0, identifiers, identifiers.length - src.length, src.length);
            } else if (identifiers.length > demandLength) {
                byte[] src = identifiers;
                identifiers = new byte[demandLength];
                System.arraycopy(src, 0, identifiers, 0, identifiers.length);
            }
            this.identifiers = identifiers;
            return this;
        }

        public Builder setIdentifiers(String hexIdentifier) {
            Objects.requireNonNull(hexIdentifier);
            if (CheckUtils.isNotHexString(hexIdentifier)) {
                throw new InvalidParameterException("hexIdentifier must be a hexadecimal string!");
            }
            byte[] identifiers = ArrayUtils.hexStringToBytes(hexIdentifier);
            return this.setIdentifiers(identifiers);
        }

        public Identifier build() {
            if (this.identifiers == null) {
                this.identifiers = new byte[12];
            }
            return new Identifier(this);
        }
    }
}

