/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import java.security.InvalidParameterException;

public class FreqUserDefine {
    private int freqStart;
    private int freqInterval;
    private byte freqQuantity;

    FreqUserDefine(Builder builder) {
        this.freqStart = builder.freqStart;
        this.freqInterval = builder.freqInterval;
        this.freqQuantity = builder.freqQuantity;
    }

    public int getFreqStart() {
        return this.freqStart;
    }

    public int getFreqInterval() {
        return this.freqInterval;
    }

    public byte getFreqQuantity() {
        return this.freqQuantity;
    }

    public String toString() {
        return "FreqUserDefine{freqStart=" + this.freqStart + ", freqInterval=" + this.freqInterval + ", freqQuantity=" + (this.freqQuantity & 0xFF) + '}';
    }

    public static class Builder {
        private int freqStart = 902000;
        private int freqInterval = 500;
        private byte freqQuantity = (byte)52;

        public Builder setFreqStart(int freqStart) {
            if (freqStart <= 0) {
                throw new InvalidParameterException("Start frequency must be greater than zero");
            }
            this.freqStart = freqStart;
            return this;
        }

        public Builder setFreqInterval(int freqInterval) {
            if (freqInterval <= 0) {
                throw new InvalidParameterException("Frequency interval must be greater than zero");
            }
            this.freqInterval = freqInterval;
            return this;
        }

        public Builder setFreqQuantity(byte freqQuantity) {
            this.freqQuantity = freqQuantity;
            return this;
        }

        public FreqUserDefine build() {
            return new FreqUserDefine(this);
        }
    }
}

