/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.bean.config.Freq;
import com.payne.reader.bean.config.Region;
import java.util.Objects;

public class FreqNormal {
    private Region region;
    private Freq freqStart;
    private Freq freqEnd;

    FreqNormal(Builder builder) {
        this.region = builder.region;
        this.freqStart = builder.freqStart;
        this.freqEnd = builder.freqEnd;
    }

    public Region getRegion() {
        return this.region;
    }

    public Freq getFreqStart() {
        return this.freqStart;
    }

    public Freq getFreqEnd() {
        return this.freqEnd;
    }

    public String toString() {
        return "FreqNormal{region=" + this.region.toString() + ", freqStart=" + this.freqStart.toString() + ", freqEnd=" + this.freqEnd.toString() + '}';
    }

    public static class Builder {
        private Region region = Region.FCC;
        private Freq freqStart = Freq._902000;
        private Freq freqEnd = Freq._928000;

        public Builder setRegion(Region region) {
            Objects.requireNonNull(region);
            this.region = region;
            return this;
        }

        public Builder setFreqStart(Freq freqStart) {
            Objects.requireNonNull(freqStart);
            this.freqStart = freqStart;
            return this;
        }

        public Builder setFreqEnd(Freq freqEnd) {
            Objects.requireNonNull(freqEnd);
            this.freqEnd = freqEnd;
            return this;
        }

        public FreqNormal build() {
            return new FreqNormal(this);
        }
    }
}

