/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.base.BaseInventory;
import com.payne.reader.bean.config.SelectFlag;
import com.payne.reader.bean.config.Session;
import com.payne.reader.bean.config.SwitchType;
import com.payne.reader.bean.config.Target;
import java.util.Objects;

public class CustomSessionTargetInventory
extends BaseInventory {
    private final byte[] inventoryParams;
    private final boolean enablePhase;

    CustomSessionTargetInventory(byte session, byte target, byte selectFlag, byte phase, byte powerSave, byte repeat) {
        boolean bl = this.enablePhase = SwitchType.getValue(true) == phase;
        if (powerSave != 0) {
            if (SelectFlag.DISABLE.getValue() == selectFlag) {
                selectFlag = SelectFlag.SL0.getValue();
            }
            this.inventoryParams = new byte[]{session, target, selectFlag, phase, powerSave, repeat};
        } else if (this.enablePhase) {
            if (SelectFlag.DISABLE.getValue() == selectFlag) {
                selectFlag = SelectFlag.SL0.getValue();
            }
            this.inventoryParams = new byte[]{session, target, selectFlag, phase, repeat};
        } else {
            this.inventoryParams = SelectFlag.DISABLE.getValue() != selectFlag ? new byte[]{session, target, selectFlag, repeat} : new byte[]{session, target, repeat};
        }
    }

    @Override
    public byte[] getInventoryParams() {
        return this.inventoryParams;
    }

    @Override
    public byte[] getHighEightAntennaInventoryParams() {
        return this.inventoryParams;
    }

    @Override
    public boolean enablePhase() {
        return this.enablePhase;
    }

    public static class Builder {
        private byte session = Session.S1.getValue();
        private byte target = Target.A.getValue();
        private byte selectFlag = SelectFlag.DISABLE.getValue();
        private byte phase = SwitchType.getValue(false);
        private byte powerSave = 0;
        private byte repeat = 1;

        public Builder session(Session session) {
            Objects.requireNonNull(session, "session == null");
            this.session = session.getValue();
            return this;
        }

        public Builder target(Target target) {
            Objects.requireNonNull(target, "target == null");
            this.target = target.getValue();
            return this;
        }

        public Builder selectFlag(SelectFlag selectFlag) {
            Objects.requireNonNull(selectFlag, "selectFlag == null");
            this.selectFlag = selectFlag.getValue();
            return this;
        }

        public Builder enablePhase(boolean enablePhase) {
            this.phase = SwitchType.getValue(enablePhase);
            return this;
        }

        public Builder powerSave(byte powerSave) {
            this.powerSave = powerSave;
            return this;
        }

        public Builder repeat(byte repeat) {
            this.repeat = repeat;
            return this;
        }

        public CustomSessionTargetInventory build() {
            return new CustomSessionTargetInventory(this.session, this.target, this.selectFlag, this.phase, this.powerSave, this.repeat);
        }
    }
}

