/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.bean.config.ReadMode;
import com.payne.reader.bean.config.Session;
import com.payne.reader.bean.config.Target;
import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public final class CustomSessionReadConfig {
    private byte[] readInfo;

    CustomSessionReadConfig(Builder builder) {
        int pwLen = builder.passwords.length;
        this.readInfo = new byte[pwLen + 10];
        this.readInfo[0] = builder.resStartAddress;
        this.readInfo[1] = builder.resLength;
        this.readInfo[2] = builder.tidStartAddress;
        this.readInfo[3] = builder.tidLength;
        this.readInfo[4] = builder.userStartAddress;
        this.readInfo[5] = builder.userLength;
        System.arraycopy(builder.passwords, 0, this.readInfo, 6, pwLen);
        this.readInfo[pwLen + 6] = builder.session;
        this.readInfo[pwLen + 7] = builder.target;
        this.readInfo[pwLen + 8] = builder.readMode;
        this.readInfo[pwLen + 9] = builder.timeout;
    }

    public byte[] getReadInfo() {
        return this.readInfo;
    }

    public static class Builder {
        private byte[] passwords = null;
        private byte resStartAddress = 0;
        private byte resLength = 0;
        private byte tidStartAddress = 0;
        private byte tidLength = 0;
        private byte userStartAddress = 0;
        private byte userLength = 0;
        private byte session = Session.S0.getValue();
        private byte target = Target.A.getValue();
        private byte readMode = ReadMode.MODE1.getValue();
        private byte timeout = (byte)5;

        public Builder setPasswords(byte[] passwords) {
            Objects.requireNonNull(passwords);
            int demandLength = 4;
            if (passwords.length < demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, src.length);
                for (int i = src.length; i < passwords.length; ++i) {
                    passwords[i] = -1;
                }
            } else if (passwords.length > demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, passwords.length);
            }
            this.passwords = passwords;
            return this;
        }

        public Builder setPasswords(String hexPassword) {
            Objects.requireNonNull(hexPassword);
            if (CheckUtils.isNotHexString(hexPassword)) {
                throw new InvalidParameterException("hexPassword must be a hexadecimal string!");
            }
            byte[] identifiers = ArrayUtils.hexStringToBytes(hexPassword);
            return this.setPasswords(identifiers);
        }

        public Builder setResStartAddress(byte resStartAddress) {
            this.resStartAddress = resStartAddress;
            return this;
        }

        public Builder setResLength(byte resLength) {
            this.resLength = resLength;
            return this;
        }

        public Builder setTidStartAddress(byte tidStartAddress) {
            this.tidStartAddress = tidStartAddress;
            return this;
        }

        public Builder setTidLength(byte tidLength) {
            this.tidLength = tidLength;
            return this;
        }

        public Builder setUserStartAddress(byte userStartAddress) {
            this.userStartAddress = userStartAddress;
            return this;
        }

        public Builder setUserLength(byte userLength) {
            this.userLength = userLength;
            return this;
        }

        public Builder setSession(Session session) {
            Objects.requireNonNull(session);
            this.session = session.getValue();
            return this;
        }

        public Builder setTarget(Target target) {
            Objects.requireNonNull(target);
            this.target = target.getValue();
            return this;
        }

        public Builder setReadMode(ReadMode readMode) {
            Objects.requireNonNull(readMode);
            this.readMode = readMode.getValue();
            return this;
        }

        public Builder setTimeout(byte timeout) {
            this.timeout = timeout;
            return this;
        }

        public CustomSessionReadConfig build() {
            if (this.passwords == null) {
                byte[] passwords = new byte[]{-1, -1, -1, -1};
                this.setPasswords(passwords);
            }
            return new CustomSessionReadConfig(this);
        }
    }
}

