/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader;

import com.payne.reader.base.Consumer;
import com.payne.reader.bean.config.AntennaCount;
import com.payne.reader.bean.config.BaudRate;
import com.payne.reader.bean.config.Beeper;
import com.payne.reader.bean.config.ClearMaskId;
import com.payne.reader.bean.config.CmdStatus;
import com.payne.reader.bean.config.FastTidType;
import com.payne.reader.bean.config.GpioInType;
import com.payne.reader.bean.config.ProfileId;
import com.payne.reader.bean.receive.AntConnectionDetector;
import com.payne.reader.bean.receive.Failure;
import com.payne.reader.bean.receive.FreqRegionResult;
import com.payne.reader.bean.receive.GpioOut;
import com.payne.reader.bean.receive.ImpinjFastTid;
import com.payne.reader.bean.receive.MaskInfo;
import com.payne.reader.bean.receive.MatchInfo;
import com.payne.reader.bean.receive.OperationTag;
import com.payne.reader.bean.receive.OutputPower;
import com.payne.reader.bean.receive.ReaderIdentifier;
import com.payne.reader.bean.receive.ReaderStatus;
import com.payne.reader.bean.receive.ReaderTemperature;
import com.payne.reader.bean.receive.ReceiveData;
import com.payne.reader.bean.receive.RfLinkProfile;
import com.payne.reader.bean.receive.RfPortReturnLoss;
import com.payne.reader.bean.receive.Success;
import com.payne.reader.bean.receive.TempLabel2;
import com.payne.reader.bean.receive.Version;
import com.payne.reader.bean.receive.WorkAntenna;
import com.payne.reader.bean.send.CustomSessionReadConfig;
import com.payne.reader.bean.send.FreqNormal;
import com.payne.reader.bean.send.FreqUserDefine;
import com.payne.reader.bean.send.Identifier;
import com.payne.reader.bean.send.InventoryConfig;
import com.payne.reader.bean.send.KillConfig;
import com.payne.reader.bean.send.LockConfig;
import com.payne.reader.bean.send.MaskConfig;
import com.payne.reader.bean.send.MatchConfig;
import com.payne.reader.bean.send.OutputPowerConfig;
import com.payne.reader.bean.send.ReadConfig;
import com.payne.reader.bean.send.TempLabel2Config;
import com.payne.reader.bean.send.WriteConfig;
import com.payne.reader.communication.ConnectHandle;
import com.payne.reader.communication.DataPacket;
import java.security.InvalidParameterException;

public interface Reader {
    public boolean connect(ConnectHandle var1);

    public boolean connect(ConnectHandle var1, boolean var2);

    public boolean isConnected();

    public void disconnect();

    public byte getReaderAddress();

    public AntennaCount getAntennaCount();

    public void switchAntennaCount(AntennaCount var1);

    public void setCmdTimeout(long var1);

    public void reset(Consumer<Failure> var1);

    public void setBaudRate(BaudRate var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void setReaderAddress(byte var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void getFirmwareVersion(Consumer<Version> var1, Consumer<Failure> var2);

    public void setBeeperMode(Beeper var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void getReaderTemperature(Consumer<ReaderTemperature> var1, Consumer<Failure> var2);

    public void readGpio(Consumer<GpioOut> var1, Consumer<Failure> var2);

    public void writeGpio(GpioInType var1, boolean var2, Consumer<Success> var3, Consumer<Failure> var4);

    public void setAntConnectionDetector(byte var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void getAntConnectionDetector(Consumer<AntConnectionDetector> var1, Consumer<Failure> var2);

    public void setWorkAntenna(int var1, Consumer<Success> var2, Consumer<Failure> var3) throws InvalidParameterException;

    public void getWorkAntenna(Consumer<WorkAntenna> var1, Consumer<Failure> var2);

    public int getCacheWorkAntenna();

    public int getCacheAntennaGroup();

    public void setOutputPower(OutputPowerConfig var1, Consumer<Success> var2, Consumer<Failure> var3) throws InvalidParameterException;

    public void getOutputPower(Consumer<OutputPower> var1, Consumer<Failure> var2);

    public void setOutputPowerUniformly(byte var1, boolean var2, Consumer<Success> var3, Consumer<Failure> var4);

    public void setFrequencyRegion(FreqNormal var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void setUserDefineFrequency(FreqUserDefine var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void getFrequencyRegion(Consumer<FreqRegionResult> var1, Consumer<Failure> var2);

    public void setReaderIdentifier(Identifier var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void getReaderIdentifier(Consumer<ReaderIdentifier> var1, Consumer<Failure> var2);

    public void setRfLinkProfile(ProfileId var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void getRfLinkProfile(Consumer<RfLinkProfile> var1, Consumer<Failure> var2);

    public void getRfPortReturnLoss(byte var1, Consumer<RfPortReturnLoss> var2, Consumer<Failure> var3);

    public void setInventoryConfig(InventoryConfig var1) throws InvalidParameterException;

    public void startInventory(boolean var1);

    public void stopInventory();

    public void readTag(ReadConfig var1, Consumer<OperationTag> var2, Consumer<Failure> var3);

    public void readTag(CustomSessionReadConfig var1, Consumer<OperationTag> var2, Consumer<Failure> var3);

    public void writeTag(WriteConfig var1, boolean var2, Consumer<OperationTag> var3, Consumer<Failure> var4);

    public void lockTag(LockConfig var1, Consumer<OperationTag> var2, Consumer<Failure> var3);

    public void killTag(KillConfig var1, Consumer<OperationTag> var2, Consumer<Failure> var3);

    public void setImpinjFastTid(FastTidType var1, boolean var2, Consumer<Success> var3, Consumer<Failure> var4);

    public void getImpinjFastTid(Consumer<ImpinjFastTid> var1, Consumer<Failure> var2);

    public void setEpcMatch(MatchConfig var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void getEpcMatch(Consumer<MatchInfo> var1, Consumer<Failure> var2);

    public void clearEpcMatch(Consumer<Success> var1, Consumer<Failure> var2);

    public void setTagMask(MaskConfig var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void getTagMask(Consumer<MaskInfo> var1, Consumer<Failure> var2);

    public void clearTagMask(ClearMaskId var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void setReaderStatus(byte var1, Consumer<Success> var2, Consumer<Failure> var3);

    public void getReaderStatus(Consumer<ReaderStatus> var1, Consumer<Failure> var2);

    public void measTempLabel2(TempLabel2Config var1, Consumer<TempLabel2> var2, Consumer<Failure> var3);

    public void setCommandStatusCallback(Consumer<CmdStatus> var1);

    public void setOriginalDataCallback(Consumer<byte[]> var1, Consumer<byte[]> var2);

    public void setUndefinedResultCallback(Consumer<ReceiveData> var1);

    public void sendCustomRequest(byte var1, byte[] var2);

    public void sendCustomRequest(DataPacket var1);
}

