/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.html;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.modules.output.html.HtmlOutputProcessor;
import org.jfree.layouting.modules.output.html.HtmlOutputProcessorMetaData;
import org.jfree.layouting.modules.output.html.HtmlPrinter;
import org.jfree.layouting.output.AbstractOutputProcessor;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.renderer.PrototypeBuildingRenderer;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.renderer.StreamingRenderer;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.dummy.DummyRepository;

public class StreamingHtmlOutputProcessor
extends AbstractOutputProcessor
implements HtmlOutputProcessor {
    private HtmlOutputProcessorMetaData metaData;
    private PrototypeBuildingRenderer prototypeBuilder;
    private HtmlPrinter printer;

    public StreamingHtmlOutputProcessor(Configuration configuration) {
        super(configuration);
        AWTFontRegistry aWTFontRegistry = new AWTFontRegistry();
        DefaultFontStorage defaultFontStorage = new DefaultFontStorage((FontRegistry)aWTFontRegistry);
        this.metaData = new HtmlOutputProcessorMetaData((FontStorage)defaultFontStorage, 0);
        ContentLocation contentLocation = new DummyRepository().getRoot();
        DefaultNameGenerator defaultNameGenerator = new DefaultNameGenerator(contentLocation);
        ContentLocation contentLocation2 = new DummyRepository().getRoot();
        DefaultNameGenerator defaultNameGenerator2 = new DefaultNameGenerator(contentLocation2);
        this.printer = new HtmlPrinter();
        this.printer.setContentWriter(contentLocation, (NameGenerator)defaultNameGenerator);
        this.printer.setDataWriter(contentLocation2, (NameGenerator)defaultNameGenerator2);
    }

    @Override
    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public Renderer createRenderer(LayoutProcess layoutProcess) {
        if (!this.isGlobalStateComputed()) {
            this.prototypeBuilder = new PrototypeBuildingRenderer(layoutProcess);
            return this.prototypeBuilder;
        }
        return new StreamingRenderer(layoutProcess);
    }

    @Override
    protected void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPageBox) {
        try {
            this.printer.generate(logicalPageBox, this.getDocumentContext());
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    @Override
    public HtmlPrinter getPrinter() {
        return this.printer;
    }

    @Override
    public void setPrinter(HtmlPrinter htmlPrinter) {
        this.printer = htmlPrinter;
    }
}

