/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.layouting.util.ChainingCallException;

public abstract class ChainingComponent {
    public static final int STATE_FRESH = 0;
    public static final int STATE_ERROR = 1;
    public static final int STATE_DONE = 2;
    private ArrayList calls = new ArrayList();

    public void addCall(RecordedCall recordedCall) {
        this.calls.add(recordedCall);
    }

    public void clear() {
        this.calls.clear();
    }

    protected RecordedCall[] retrieveRecordedCalls() {
        RecordedCall[] recordedCallArray = this.calls.toArray(new RecordedCall[this.calls.size()]);
        this.calls.clear();
        return recordedCallArray;
    }

    public void setRecordedCalls(RecordedCall[] recordedCallArray) {
        this.calls.addAll(Arrays.asList(recordedCallArray));
    }

    public synchronized void replay(Object object) throws ChainingCallException {
        RecordedCall[] recordedCallArray = this.retrieveRecordedCalls();
        for (int i = 0; i < recordedCallArray.length; ++i) {
            RecordedCall recordedCall = recordedCallArray[i];
            if (recordedCall.getState() != 0) continue;
            try {
                this.invoke(object, recordedCall.getMethod(), recordedCall.getParameters());
                recordedCall.setState(2);
                continue;
            }
            catch (Exception exception) {
                recordedCall.setState(1);
                throw new ChainingCallException("Chained Call failed:", exception);
            }
        }
    }

    protected abstract void invoke(Object var1, int var2, Object var3) throws Exception;

    public static class RecordedCall {
        private int methodId;
        private Object parameters;
        private int state;

        public RecordedCall(int n, Object object) {
            this.methodId = n;
            this.parameters = object;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int n) {
            this.state = n;
        }

        public int getMethod() {
            return this.methodId;
        }

        public Object getParameters() {
            return this.parameters;
        }
    }
}

