/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.text.font;

import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.text.font.KerningProducer;

public class DefaultKerningProducer
implements KerningProducer {
    private int lastCodePoint;
    private FontMetrics fontMetrics;

    public DefaultKerningProducer(FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            throw new NullPointerException();
        }
        this.fontMetrics = fontMetrics;
    }

    @Override
    public long getKerning(int codePoint) {
        if (codePoint == Integer.MIN_VALUE || codePoint == Integer.MAX_VALUE) {
            this.lastCodePoint = 0;
            return 0L;
        }
        long d = this.fontMetrics.getKerning(this.lastCodePoint, codePoint);
        this.lastCodePoint = codePoint;
        return d;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

