/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.expressions;

import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.formula.ContextEvaluationException;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;
import org.pentaho.reporting.libraries.formula.operators.OperatorFactory;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class ReportFormulaContext
implements FormulaContext {
    private FormulaContext backend;
    private DataRow dataRow;
    private Object declaringElement;

    public ReportFormulaContext(FormulaContext formulaContext, DataRow dataRow) {
        this.backend = formulaContext;
        this.dataRow = dataRow;
    }

    public LocalizationContext getLocalizationContext() {
        return this.backend.getLocalizationContext();
    }

    public Configuration getConfiguration() {
        return this.backend.getConfiguration();
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.backend.getFunctionRegistry();
    }

    public TypeRegistry getTypeRegistry() {
        return this.backend.getTypeRegistry();
    }

    public OperatorFactory getOperatorFactory() {
        return this.backend.getOperatorFactory();
    }

    public boolean isReferenceDirty(Object object) throws ContextEvaluationException {
        try {
            DataFlags dataFlags = this.dataRow.getFlags(String.valueOf(object));
            if (dataFlags == null) {
                throw new ContextEvaluationException((ErrorValue)new LibFormulaErrorValue(499));
            }
            return dataFlags.isChanged();
        }
        catch (Exception exception) {
            throw new ContextEvaluationException((ErrorValue)new LibFormulaErrorValue(499));
        }
    }

    public Type resolveReferenceType(Object object) {
        try {
            DataFlags dataFlags = this.dataRow.getFlags(String.valueOf(object));
            if (dataFlags != null) {
                if (dataFlags.isDate()) {
                    return DateTimeType.DATETIME_TYPE;
                }
                if (dataFlags.isNumeric()) {
                    return NumberType.GENERIC_NUMBER;
                }
                return TextType.TYPE;
            }
        }
        catch (DataSourceException dataSourceException) {
            // empty catch block
        }
        return AnyType.TYPE;
    }

    public Object resolveReference(Object object) throws ContextEvaluationException {
        if (object == null) {
            throw new NullPointerException();
        }
        try {
            return this.dataRow.get(String.valueOf(object));
        }
        catch (DataSourceException dataSourceException) {
            DebugLog.log((Object)"Error while resolving formula reference: ", (Throwable)((Object)dataSourceException));
            throw new ContextEvaluationException((ErrorValue)new LibFormulaErrorValue(499));
        }
    }

    public DataRow getDataRow() {
        return this.dataRow;
    }

    public void setDataRow(DataRow dataRow) {
        this.dataRow = dataRow;
    }

    public Object getDeclaringElement() {
        return this.declaringElement;
    }

    public void setDeclaringElement(Object object) {
        this.declaringElement = object;
    }
}

