/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.parser;

import java.io.StringReader;
import org.pentaho.reporting.libraries.formula.LibFormulaBoot;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.operators.DefaultOperatorFactory;
import org.pentaho.reporting.libraries.formula.operators.OperatorFactory;
import org.pentaho.reporting.libraries.formula.parser.FormulaParseException;
import org.pentaho.reporting.libraries.formula.parser.GeneratedFormulaParser;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormulaParser
extends GeneratedFormulaParser {
    private OperatorFactory operatorFactory = new DefaultOperatorFactory();

    public FormulaParser() {
        super(new StringReader(""));
        this.operatorFactory.initalize(LibFormulaBoot.getInstance().getGlobalConfig());
    }

    @Override
    protected OperatorFactory getOperatorFactory() {
        return this.operatorFactory;
    }

    @Override
    public ParseException generateParseException() {
        ParseException parent = super.generateParseException();
        return new FormulaParseException(parent.currentToken, parent.expectedTokenSequences, parent.tokenImage);
    }

    public LValue parse(String formula) throws ParseException {
        if (formula == null) {
            throw new NullPointerException("Formula-text given must not be null.");
        }
        try {
            this.ReInit(new StringReader(formula));
            LValue expression = this.getExpression();
            if (this.token.next != null && this.token.next.image.length() > 0) {
                throw new FormulaParseException("Extra content: '" + this.token.next.image + "'");
            }
            return expression;
        }
        catch (ParseException pe) {
            if (pe instanceof FormulaParseException) {
                throw pe;
            }
            throw new FormulaParseException(pe);
        }
    }

    public static void main(String[] args) throws ParseException {
        LibFormulaBoot.getInstance().start();
        FormulaParser formulaParser = new FormulaParser();
        formulaParser.enable_tracing();
        System.out.println("LValue: " + formulaParser.parse("[\\n]"));
        System.out.println("LValue: " + formulaParser.parse("[\"\"]"));
        String s = "[\\\\]";
        System.out.println("[\\\\]");
        System.out.println("LValue: " + formulaParser.parse("[\\\\]"));
        System.out.println("LValue: " + formulaParser.parse("T(\"a\\\\\") = \"a\""));
        System.out.println("LValue: " + formulaParser.parse("[\"[OK]\"]"));
    }
}

