/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.bridges.jni_uno;

import com.sun.star.bridges.jni_uno.JNI_info_holder;
import com.sun.star.lib.util.AsynchronousFinalizer;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.IQueryInterface;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class JNI_proxy
implements InvocationHandler {
    private static ClassLoader s_classloader;
    private static Class[] s_InvocationHandler;
    private long m_bridge_handle;
    private final IEnvironment m_java_env;
    private long m_receiver_handle;
    private long m_td_handle;
    private final Type m_type;
    private final String m_oid;
    private final Class m_class;
    private final AsynchronousFinalizer m_finalizer;

    public static String get_stack_trace(Throwable throwable) throws Throwable {
        boolean current_trace = false;
        if (null == throwable) {
            throwable = new Throwable();
            current_trace = true;
        }
        StringWriter string_writer = new StringWriter();
        PrintWriter print_writer = new PrintWriter((Writer)string_writer, true);
        throwable.printStackTrace(print_writer);
        print_writer.flush();
        print_writer.close();
        string_writer.flush();
        String trace = string_writer.toString();
        if (current_trace) {
            int n = trace.indexOf(10);
            n = trace.indexOf(10, n + 1);
            trace = trace.substring(n + 1);
        }
        return "\njava stack trace:\n" + trace;
    }

    private native void finalize(long var1);

    protected void finalize() {
        if (this.m_finalizer != null) {
            this.m_finalizer.add(new AsynchronousFinalizer.Job(){

                public void run() throws Throwable {
                    JNI_proxy.this.finalize(JNI_proxy.this.m_bridge_handle);
                }
            });
        }
    }

    private JNI_proxy(long bridge_handle, IEnvironment java_env, long receiver_handle, long td_handle, Type type, String oid, AsynchronousFinalizer finalizer) {
        this.m_bridge_handle = bridge_handle;
        this.m_java_env = java_env;
        this.m_receiver_handle = receiver_handle;
        this.m_td_handle = td_handle;
        this.m_type = type;
        this.m_oid = oid;
        this.m_class = this.m_type.getZClass();
        this.m_finalizer = finalizer;
    }

    public static Object create(long bridge_handle, IEnvironment java_env, long receiver_handle, long td_handle, Type type, String oid, Constructor proxy_ctor, AsynchronousFinalizer finalizer) throws Throwable {
        JNI_proxy handler = new JNI_proxy(bridge_handle, java_env, receiver_handle, td_handle, type, oid, finalizer);
        Object proxy = proxy_ctor.newInstance(handler);
        return java_env.registerInterface(proxy, new String[]{oid}, type);
    }

    public static Constructor get_proxy_ctor(Class clazz) throws Throwable {
        Class<?> proxy_class = Proxy.getProxyClass(s_classloader, clazz, IQueryInterface.class, com.sun.star.lib.uno.Proxy.class);
        return proxy_class.getConstructor(s_InvocationHandler);
    }

    private native Object dispatch_call(long var1, String var3, Object[] var4) throws Throwable;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> decl_class = method.getDeclaringClass();
        String method_name = method.getName();
        if (Object.class.equals(decl_class)) {
            if (method_name.equals("hashCode")) {
                return this.m_oid.hashCode();
            }
            if (method_name.equals("equals")) {
                return this.isSame(args[0]);
            }
            if (method_name.equals("toString")) {
                return this.toString() + " [oid=" + this.m_oid + ", type=" + this.m_type.getTypeName() + "]";
            }
        } else {
            if (decl_class.isAssignableFrom(this.m_class)) {
                return this.dispatch_call(this.m_bridge_handle, method_name, args);
            }
            if (IQueryInterface.class.equals(decl_class)) {
                if (method_name.equals("queryInterface")) {
                    Object registered_proxy = this.m_java_env.getRegisteredInterface(this.m_oid, (Type)args[0]);
                    if (null == registered_proxy) {
                        return this.dispatch_call(this.m_bridge_handle, method_name, args);
                    }
                    return registered_proxy;
                }
                if (method_name.equals("isSame")) {
                    return this.isSame(args[0]);
                }
                if (method_name.equals("getOid")) {
                    return this.m_oid;
                }
            }
        }
        throw new RuntimeException("[jni_uno bridge error] unexpected call on proxy " + proxy.toString() + ": " + method.toString());
    }

    private Boolean isSame(Object obj) {
        return obj != null && this.m_oid.equals(UnoRuntime.generateOid((Object)obj));
    }

    static {
        if ("The Android Project".equals(System.getProperty("java.vendor"))) {
            boolean disable_dynloading = false;
            try {
                System.loadLibrary("lo-bootstrap");
            }
            catch (UnsatisfiedLinkError e) {
                disable_dynloading = true;
            }
            if (!disable_dynloading) {
                NativeLibraryLoader.loadLibrary((ClassLoader)JNI_info_holder.class.getClassLoader(), (String)"java_uno");
            }
        } else {
            NativeLibraryLoader.loadLibrary((ClassLoader)JNI_proxy.class.getClassLoader(), (String)"java_uno");
        }
        s_classloader = JNI_proxy.class.getClassLoader();
        s_InvocationHandler = new Class[]{InvocationHandler.class};
    }
}

