/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.page;

import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.keys.page.PageSizeFactory;
import org.jfree.layouting.input.style.parser.stylehandler.AbstractWidthReadHandler;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class SizeReadHandler
extends AbstractWidthReadHandler {
    public SizeReadHandler() {
        super(true, false);
    }

    @Override
    public CSSValue createValue(StyleKey styleKey, LexicalUnit lexicalUnit) {
        CSSNumericValue cSSNumericValue;
        if (lexicalUnit.getLexicalUnitType() == 35) {
            String string = lexicalUnit.getStringValue();
            if ("auto".equalsIgnoreCase(string)) {
                return CSSAutoValue.getInstance();
            }
            PageSize pageSize = PageSizeFactory.getInstance().getPageSizeByName(string);
            if (pageSize == null) {
                return null;
            }
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
            int n = 1;
            if (lexicalUnit != null) {
                if (lexicalUnit.getLexicalUnitType() != 35) {
                    return null;
                }
                if ("landscape".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                    n = 0;
                } else if ("reverse-landscape".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                    n = 2;
                } else if ("portrait".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                    n = 1;
                } else {
                    return null;
                }
            }
            if (n == 0 || n == 2) {
                return new CSSValuePair(CSSNumericValue.createPtValue(pageSize.getHeight()), CSSNumericValue.createPtValue(pageSize.getWidth()));
            }
            return new CSSValuePair(CSSNumericValue.createPtValue(pageSize.getWidth()), CSSNumericValue.createPtValue(pageSize.getHeight()));
        }
        CSSNumericValue cSSNumericValue2 = (CSSNumericValue)this.parseWidth(lexicalUnit);
        if (cSSNumericValue2 == null) {
            return null;
        }
        if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
            cSSNumericValue = cSSNumericValue2;
        } else {
            cSSNumericValue = (CSSNumericValue)this.parseWidth(lexicalUnit);
            if (cSSNumericValue == null) {
                return null;
            }
        }
        return new CSSValuePair(cSSNumericValue2, cSSNumericValue);
    }
}

