/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.percentages.text;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public class WordSpacingResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE, FontStyleKeys.FONT_FAMILY, FontStyleKeys.FONT_EFFECT, FontStyleKeys.FONT_SMOOTH, FontStyleKeys.FONT_STRETCH, FontStyleKeys.FONT_VARIANT, FontStyleKeys.FONT_WEIGHT};
    }

    @Override
    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        FontMetrics fontMetrics = layoutProcess.getOutputMetaData().getFontMetrics(fontSpecification);
        if (fontMetrics == null) {
            CSSValue cSSValue = layoutContext.getValue(FontStyleKeys.FONT_FAMILY);
            DebugLog.log((Object)("FontFamily is " + cSSValue + " but has not been set?" + layoutElement));
            return;
        }
        double d = StrictGeomUtility.toExternalValue(fontMetrics.getCharWidth(32));
        CSSNumericValue cSSNumericValue = CSSNumericValue.createValue(CSSNumericType.PT, d);
        CSSNumericValue cSSNumericValue2 = CSSValueResolverUtility.getLength(this.resolveValue(layoutContext, TextStyleKeys.X_MIN_WORD_SPACING), cSSNumericValue);
        CSSNumericValue cSSNumericValue3 = CSSValueResolverUtility.getLength(this.resolveValue(layoutContext, TextStyleKeys.X_MAX_WORD_SPACING), cSSNumericValue);
        CSSNumericValue cSSNumericValue4 = CSSValueResolverUtility.getLength(this.resolveValue(layoutContext, TextStyleKeys.X_OPTIMUM_WORD_SPACING), cSSNumericValue);
        layoutContext.setValue(TextStyleKeys.X_MIN_WORD_SPACING, cSSNumericValue2);
        layoutContext.setValue(TextStyleKeys.X_MAX_WORD_SPACING, cSSNumericValue3);
        layoutContext.setValue(TextStyleKeys.X_OPTIMUM_WORD_SPACING, cSSNumericValue4);
    }

    private CSSNumericValue resolveValue(LayoutContext layoutContext, StyleKey styleKey) {
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (!(cSSValue instanceof CSSNumericValue)) {
            return CSSNumericValue.ZERO_LENGTH;
        }
        return (CSSNumericValue)cSSValue;
    }
}

