/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.model.ImageElement;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.ReportElementReadHandler;
import org.libreoffice.report.pentaho.parser.xlink.XLinkReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImageReadHandler
extends ElementReadHandler {
    private final ImageElement contentElement = new ImageElement();
    private XLinkReadHandler xLinkReadHandler;

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        String formula = attrs.getValue("http://openoffice.org/2005/report", "formula");
        if (formula != null && formula.length() != 0) {
            FormulaExpression valueExpression = new FormulaExpression();
            valueExpression.setFormula(formula);
            this.contentElement.setFormula(valueExpression);
        }
        this.contentElement.setNamespace("urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        this.contentElement.setType("image");
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(uri) && "image-data".equals(tagName)) {
            this.xLinkReadHandler = new XLinkReadHandler();
            return this.xLinkReadHandler;
        }
        if ("http://openoffice.org/2005/report".equals(uri)) {
            if ("report-control".equals(tagName)) {
                return new IgnoreAnyChildReadHandler();
            }
            if ("report-element".equals(tagName)) {
                return new ReportElementReadHandler(this.contentElement);
            }
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        if (this.xLinkReadHandler != null) {
            this.contentElement.setAttribute("http://openoffice.org/2005/report", "alternate-content", this.xLinkReadHandler.getUri());
        }
    }

    @Override
    public Element getElement() {
        return this.contentElement;
    }
}

