/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.global;

import java.util.Random;

public class RandomGenerator {
    private static Random PRNG = new Random();

    public static int intRangeRandom(int lowLimit, int upLimit) {
        int num = lowLimit + PRNG.nextInt(upLimit - lowLimit + 1);
        return num;
    }

    public static double doubleRangeRandom(double lowLimit, double upLimit) {
        double num = lowLimit + PRNG.nextDouble() * (upLimit - lowLimit);
        return num;
    }

    public static int[] randomSelection(int maxNum, int times) {
        if (maxNum < 0) {
            maxNum = 0;
        }
        if (times < 0) {
            times = 0;
        }
        int[] all = new int[maxNum];
        for (int i = 0; i < all.length; ++i) {
            all[i] = i;
        }
        int[] indices = new int[Math.min(maxNum, times)];
        for (int i = 0; i < indices.length; ++i) {
            int j = RandomGenerator.intRangeRandom(i, all.length - 1);
            int value = all[j];
            all[j] = all[i];
            indices[i] = all[i] = value;
        }
        return indices;
    }
}

