/*
 * Decompiled with CFR 0.152.
 */
package cpdetector.io;

import cpdetector.io.AbstractCodepageDetector;
import cpdetector.io.UnknownCharset;
import cpdetector.io.UnsupportedCharset;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public final class JChardetFacade
extends AbstractCodepageDetector
implements nsICharsetDetectionObserver {
    private static JChardetFacade instance = null;
    private static nsDetector det;
    private static byte[] buf;
    private Charset codpage = null;
    private boolean guessing = true;
    private int amountOfVerifiers = 0;

    private JChardetFacade() {
        det = new nsDetector(0);
        det.Init(this);
        this.amountOfVerifiers = det.getProbableCharsets().length;
    }

    public static JChardetFacade getInstance() {
        if (instance == null) {
            instance = new JChardetFacade();
        }
        return instance;
    }

    public Charset detectCodepage(URL url) throws IOException {
        return this.detectCodepage(new BufferedInputStream(url.openStream()), Integer.MAX_VALUE);
    }

    public synchronized Charset detectCodepage(InputStream in, int length) throws IOException {
        int len;
        this.Reset();
        int read = 0;
        boolean done = false;
        boolean isAscii = true;
        Charset ret = null;
        do {
            if ((len = in.read(buf, 0, Math.min(buf.length, length - read))) > 0) {
                read += len;
            }
            if (done) continue;
            done = det.DoIt(buf, len, false);
        } while (len != -1 && !done);
        det.DataEnd();
        ret = this.codpage == null ? (this.guessing ? this.guess() : UnknownCharset.getInstance()) : this.codpage;
        return ret;
    }

    private Charset guess() {
        Charset ret = null;
        String[] possibilities = det.getProbableCharsets();
        System.out.println("Possible Charsets: ");
        for (int i = 0; i < possibilities.length; ++i) {
            System.out.println(possibilities[i]);
        }
        if (possibilities.length == this.amountOfVerifiers) {
            ret = Charset.forName("US-ASCII");
        } else {
            String check = possibilities[0];
            if (check.equalsIgnoreCase("nomatch")) {
                ret = UnknownCharset.getInstance();
            } else {
                for (int i = 0; ret == null && i < possibilities.length; ++i) {
                    try {
                        ret = Charset.forName(possibilities[i]);
                        continue;
                    }
                    catch (UnsupportedCharsetException uce) {
                        ret = UnsupportedCharset.forName(possibilities[i]);
                    }
                }
            }
        }
        return ret;
    }

    public void Notify(String charset) {
        this.codpage = Charset.forName(charset);
    }

    public void Reset() {
        det.Reset();
        this.codpage = null;
    }

    public boolean isGuessing() {
        return this.guessing;
    }

    public synchronized void setGuessing(boolean guessing) {
        this.guessing = guessing;
    }

    static {
        buf = new byte[4096];
    }
}

