/*
 * Decompiled with CFR 0.152.
 */
package cpdetector.io;

import cpdetector.io.AbstractCodepageDetector;
import cpdetector.io.ICodepageDetector;
import cpdetector.io.UnknownCharset;
import cpdetector.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;

public class ASCIIDetector
extends AbstractCodepageDetector {
    private static ICodepageDetector instance;

    private ASCIIDetector() {
    }

    public static ICodepageDetector getInstance() {
        if (instance == null) {
            instance = new ASCIIDetector();
        }
        return instance;
    }

    public Charset detectCodepage(InputStream in, int length) throws IOException {
        Charset ret = UnknownCharset.getInstance();
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in, 4096);
        }
        if (FileUtil.isAllASCII(in)) {
            ret = Charset.forName("US-ASCII");
        }
        return ret;
    }

    public Charset detectCodepage(URL url) throws IOException {
        return this.detectCodepage(new BufferedInputStream(url.openStream()), Integer.MAX_VALUE);
    }
}

