/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.digests.SHA1Digest;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.cad.internal.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.MessageEncryptor;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.a;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.b;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.c;
import com.aspose.cad.internal.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import com.aspose.cad.internal.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.aspose.cad.internal.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import java.security.SecureRandom;

public class McElieceKobaraImaiCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2.3";
    private static final String a = "SHA1PRNG";
    public static final byte[] PUBLIC_CONSTANT = "a predetermined public constant".getBytes();
    private Digest b;
    private SecureRandom c;
    McElieceCCA2KeyParameters key;
    private int d;
    private int e;
    private int f;
    private boolean g;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.g = bl2;
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.c = parametersWithRandom.getRandom();
                this.key = (McElieceCCA2PublicKeyParameters)parametersWithRandom.getParameters();
                this.a((McElieceCCA2PublicKeyParameters)this.key);
            } else {
                this.c = new SecureRandom();
                this.key = (McElieceCCA2PublicKeyParameters)cipherParameters;
                this.a((McElieceCCA2PublicKeyParameters)this.key);
            }
        } else {
            this.key = (McElieceCCA2PrivateKeyParameters)cipherParameters;
            this.a((McElieceCCA2PrivateKeyParameters)this.key);
        }
    }

    public int getKeySize(McElieceCCA2KeyParameters mcElieceCCA2KeyParameters) {
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PublicKeyParameters) {
            return ((McElieceCCA2PublicKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PrivateKeyParameters) {
            return ((McElieceCCA2PrivateKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    private void a(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.b = com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.c.a(mcElieceCCA2PublicKeyParameters.getDigest());
        this.d = mcElieceCCA2PublicKeyParameters.getN();
        this.e = mcElieceCCA2PublicKeyParameters.getK();
        this.f = mcElieceCCA2PublicKeyParameters.getT();
    }

    private void a(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this.b = com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.c.a(mcElieceCCA2PrivateKeyParameters.getDigest());
        this.d = mcElieceCCA2PrivateKeyParameters.getN();
        this.e = mcElieceCCA2PrivateKeyParameters.getK();
        this.f = mcElieceCCA2PrivateKeyParameters.getT();
    }

    @Override
    public byte[] messageEncrypt(byte[] byArray) {
        if (!this.g) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        int n2 = this.b.getDigestSize();
        int n3 = this.e >> 3;
        int n4 = IntegerFunctions.binomial(this.d, this.f).bitLength() - 1 >> 3;
        int n5 = n3 + n4 - n2 - PUBLIC_CONSTANT.length;
        if (byArray.length > n5) {
            n5 = byArray.length;
        }
        int n6 = n5 + PUBLIC_CONSTANT.length;
        int n7 = n6 + n2 - n3 - n4;
        byte[] byArray2 = new byte[n6];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(PUBLIC_CONSTANT, 0, byArray2, n5, PUBLIC_CONSTANT.length);
        byte[] byArray3 = new byte[n2];
        this.c.nextBytes(byArray3);
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray3);
        byte[] byArray4 = new byte[n6];
        digestRandomGenerator.nextBytes(byArray4);
        for (int i2 = n6 - 1; i2 >= 0; --i2) {
            int n8 = i2;
            byArray4[n8] = (byte)(byArray4[n8] ^ byArray2[i2]);
        }
        byte[] byArray5 = new byte[this.b.getDigestSize()];
        this.b.update(byArray4, 0, byArray4.length);
        this.b.doFinal(byArray5, 0);
        for (int i3 = n2 - 1; i3 >= 0; --i3) {
            int n9 = i3;
            byArray5[n9] = (byte)(byArray5[n9] ^ byArray3[i3]);
        }
        byte[] byArray6 = ByteUtils.concatenate(byArray5, byArray4);
        byte[] byArray7 = new byte[]{};
        if (n7 > 0) {
            byArray7 = new byte[n7];
            System.arraycopy(byArray6, 0, byArray7, 0, n7);
        }
        byte[] byArray8 = new byte[n4];
        System.arraycopy(byArray6, n7, byArray8, 0, n4);
        byte[] byArray9 = new byte[n3];
        System.arraycopy(byArray6, n7 + n4, byArray9, 0, n3);
        GF2Vector gF2Vector = GF2Vector.OS2VP(this.e, byArray9);
        GF2Vector gF2Vector2 = com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.a.a(this.d, this.f, byArray8);
        byte[] byArray10 = com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.b.a((McElieceCCA2PublicKeyParameters)this.key, gF2Vector, gF2Vector2).getEncoded();
        if (n7 > 0) {
            return ByteUtils.concatenate(byArray7, byArray10);
        }
        return byArray10;
    }

    @Override
    public byte[] messageDecrypt(byte[] byArray) throws InvalidCipherTextException {
        byte[] byArray2;
        byte[] byArray3;
        Object object;
        if (this.g) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        int n2 = this.d >> 3;
        if (byArray.length < n2) {
            throw new InvalidCipherTextException("Bad Padding: Ciphertext too short.");
        }
        int n3 = this.b.getDigestSize();
        int n4 = this.e >> 3;
        int n5 = byArray.length - n2;
        if (n5 > 0) {
            object = ByteUtils.split(byArray, n5);
            byArray3 = object[0];
            byArray2 = object[1];
        } else {
            byArray3 = new byte[]{};
            byArray2 = byArray;
        }
        object = GF2Vector.OS2VP(this.d, byArray2);
        GF2Vector[] gF2VectorArray = com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.b.a((McElieceCCA2PrivateKeyParameters)this.key, (GF2Vector)object);
        byte[] byArray4 = gF2VectorArray[0].getEncoded();
        GF2Vector gF2Vector = gF2VectorArray[1];
        if (byArray4.length > n4) {
            byArray4 = ByteUtils.subArray(byArray4, 0, n4);
        }
        byte[] byArray5 = com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.a.a(this.d, this.f, gF2Vector);
        byte[] byArray6 = ByteUtils.concatenate(byArray3, byArray5);
        byArray6 = ByteUtils.concatenate(byArray6, byArray4);
        int n6 = byArray6.length - n3;
        byte[][] byArray7 = ByteUtils.split(byArray6, n3);
        byte[] byArray8 = byArray7[0];
        byte[] byArray9 = byArray7[1];
        byte[] byArray10 = new byte[this.b.getDigestSize()];
        this.b.update(byArray9, 0, byArray9.length);
        this.b.doFinal(byArray10, 0);
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            int n7 = i2;
            byArray10[n7] = (byte)(byArray10[n7] ^ byArray8[i2]);
        }
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray10);
        byte[] byArray11 = new byte[n6];
        digestRandomGenerator.nextBytes(byArray11);
        for (int i3 = n6 - 1; i3 >= 0; --i3) {
            int n8 = i3;
            byArray11[n8] = (byte)(byArray11[n8] ^ byArray9[i3]);
        }
        if (byArray11.length < n6) {
            throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
        }
        byte[][] byArray12 = ByteUtils.split(byArray11, n6 - PUBLIC_CONSTANT.length);
        byte[] byArray13 = byArray12[0];
        byte[] byArray14 = byArray12[1];
        if (!ByteUtils.equals(byArray14, PUBLIC_CONSTANT)) {
            throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
        }
        return byArray13;
    }
}

