/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pqc.asn1;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class XMSSPrivateKey
extends ASN1Object {
    private final int a;
    private final byte[] b;
    private final byte[] c;
    private final byte[] d;
    private final byte[] e;
    private final byte[] f;

    public XMSSPrivateKey(int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        this.a = n2;
        this.b = Arrays.clone(byArray);
        this.c = Arrays.clone(byArray2);
        this.d = Arrays.clone(byArray3);
        this.e = Arrays.clone(byArray4);
        this.f = Arrays.clone(byArray5);
    }

    private XMSSPrivateKey(ASN1Sequence aSN1Sequence) {
        if (!ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue().equals(BigInteger.valueOf(0L))) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        if (aSN1Sequence.size() != 2 && aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("key sequence wrong size");
        }
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        this.a = ASN1Integer.getInstance(aSN1Sequence2.getObjectAt(0)).getValue().intValue();
        this.b = Arrays.clone(DEROctetString.getInstance(aSN1Sequence2.getObjectAt(1)).getOctets());
        this.c = Arrays.clone(DEROctetString.getInstance(aSN1Sequence2.getObjectAt(2)).getOctets());
        this.d = Arrays.clone(DEROctetString.getInstance(aSN1Sequence2.getObjectAt(3)).getOctets());
        this.e = Arrays.clone(DEROctetString.getInstance(aSN1Sequence2.getObjectAt(4)).getOctets());
        this.f = (byte[])(aSN1Sequence.size() == 3 ? Arrays.clone(DEROctetString.getInstance(ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(2)), true).getOctets()) : null);
    }

    public static XMSSPrivateKey getInstance(Object object) {
        if (object instanceof XMSSPrivateKey) {
            return (XMSSPrivateKey)object;
        }
        if (object != null) {
            return new XMSSPrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public int getIndex() {
        return this.a;
    }

    public byte[] getSecretKeySeed() {
        return Arrays.clone(this.b);
    }

    public byte[] getSecretKeyPRF() {
        return Arrays.clone(this.c);
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.d);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.e);
    }

    public byte[] getBdsState() {
        return Arrays.clone(this.f);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(0L));
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new ASN1Integer(this.a));
        aSN1EncodableVector2.add(new DEROctetString(this.b));
        aSN1EncodableVector2.add(new DEROctetString(this.c));
        aSN1EncodableVector2.add(new DEROctetString(this.d));
        aSN1EncodableVector2.add(new DEROctetString(this.e));
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        aSN1EncodableVector.add(new DERTaggedObject(true, 0, new DEROctetString(this.f)));
        return new DERSequence(aSN1EncodableVector);
    }
}

