/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pkcs.jcajce;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.jcajce.PKCS12Key;
import com.aspose.cad.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.operator.MacCalculator;
import com.aspose.cad.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.cad.internal.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import com.aspose.cad.internal.bouncycastle.pkcs.jcajce.a;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.PBEParameterSpec;

public class JcePKCS12MacCalculatorBuilder
implements PKCS12MacCalculatorBuilder {
    private JcaJceHelper a = new DefaultJcaJceHelper();
    private ASN1ObjectIdentifier b;
    private SecureRandom c;
    private int d;
    private int e = 1024;

    public JcePKCS12MacCalculatorBuilder() {
        this(OIWObjectIdentifiers.idSHA1);
    }

    public JcePKCS12MacCalculatorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.b = aSN1ObjectIdentifier;
    }

    public JcePKCS12MacCalculatorBuilder setProvider(Provider provider) {
        this.a = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCS12MacCalculatorBuilder setProvider(String string) {
        this.a = new NamedJcaJceHelper(string);
        return this;
    }

    public JcePKCS12MacCalculatorBuilder setIterationCount(int n2) {
        this.e = n2;
        return this;
    }

    @Override
    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return new AlgorithmIdentifier(this.b, DERNull.INSTANCE);
    }

    @Override
    public MacCalculator build(char[] cArray) throws OperatorCreationException {
        if (this.c == null) {
            this.c = new SecureRandom();
        }
        try {
            Mac mac = this.a.createMac(this.b.getId());
            this.d = mac.getMacLength();
            byte[] byArray = new byte[this.d];
            this.c.nextBytes(byArray);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, this.e);
            PKCS12Key pKCS12Key = new PKCS12Key(cArray);
            mac.init(pKCS12Key, pBEParameterSpec);
            return new a(this, byArray, mac, pKCS12Key);
        }
        catch (Exception exception) {
            throw new OperatorCreationException("unable to create MAC calculator: " + exception.getMessage(), exception);
        }
    }

    static /* synthetic */ ASN1ObjectIdentifier access$000(JcePKCS12MacCalculatorBuilder jcePKCS12MacCalculatorBuilder) {
        return jcePKCS12MacCalculatorBuilder.b;
    }

    static /* synthetic */ int access$100(JcePKCS12MacCalculatorBuilder jcePKCS12MacCalculatorBuilder) {
        return jcePKCS12MacCalculatorBuilder.e;
    }
}

