/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pkcs;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSet;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.Attribute;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.CertBag;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.SafeBag;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Certificate;
import com.aspose.cad.internal.bouncycastle.asn1.x509.CertificateList;
import com.aspose.cad.internal.bouncycastle.cert.X509CRLHolder;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.operator.OutputEncryptor;
import com.aspose.cad.internal.bouncycastle.pkcs.PKCS12SafeBag;
import com.aspose.cad.internal.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfoBuilder;
import java.io.IOException;

public class PKCS12SafeBagBuilder {
    private ASN1ObjectIdentifier a;
    private ASN1Encodable b;
    private ASN1EncodableVector c = new ASN1EncodableVector();

    public PKCS12SafeBagBuilder(PrivateKeyInfo privateKeyInfo, OutputEncryptor outputEncryptor) {
        this.a = PKCSObjectIdentifiers.pkcs8ShroudedKeyBag;
        this.b = new PKCS8EncryptedPrivateKeyInfoBuilder(privateKeyInfo).build(outputEncryptor).toASN1Structure();
    }

    public PKCS12SafeBagBuilder(PrivateKeyInfo privateKeyInfo) {
        this.a = PKCSObjectIdentifiers.keyBag;
        this.b = privateKeyInfo;
    }

    public PKCS12SafeBagBuilder(X509CertificateHolder x509CertificateHolder) throws IOException {
        this(x509CertificateHolder.toASN1Structure());
    }

    public PKCS12SafeBagBuilder(X509CRLHolder x509CRLHolder) throws IOException {
        this(x509CRLHolder.toASN1Structure());
    }

    public PKCS12SafeBagBuilder(Certificate certificate) throws IOException {
        this.a = PKCSObjectIdentifiers.certBag;
        this.b = new CertBag(PKCSObjectIdentifiers.x509Certificate, new DEROctetString(certificate.getEncoded()));
    }

    public PKCS12SafeBagBuilder(CertificateList certificateList) throws IOException {
        this.a = PKCSObjectIdentifiers.crlBag;
        this.b = new CertBag(PKCSObjectIdentifiers.x509Crl, new DEROctetString(certificateList.getEncoded()));
    }

    public PKCS12SafeBagBuilder addBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.c.add(new Attribute(aSN1ObjectIdentifier, new DERSet(aSN1Encodable)));
        return this;
    }

    public PKCS12SafeBag build() {
        return new PKCS12SafeBag(new SafeBag(this.a, this.b, new DERSet(this.c)));
    }
}

