/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.openssl.jcajce;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.cad.internal.bouncycastle.openssl.EncryptionException;
import com.aspose.cad.internal.bouncycastle.openssl.PEMException;
import com.aspose.cad.internal.bouncycastle.util.Integers;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class h {
    private static final Map a = new HashMap();
    private static final Set b = new HashSet();
    private static final Set c = new HashSet();
    private static final Map d = new HashMap();
    private static final Map e = new HashMap();

    h() {
    }

    static int a(String string) {
        if (!a.containsKey(string)) {
            throw new IllegalStateException("no key size for algorithm: " + string);
        }
        return (Integer)a.get(string);
    }

    static int a(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (!e.containsKey(aSN1ObjectIdentifier)) {
            throw new IllegalStateException("no salt size for algorithm: " + aSN1ObjectIdentifier);
        }
        return (Integer)e.get(aSN1ObjectIdentifier);
    }

    static boolean a(AlgorithmIdentifier algorithmIdentifier) {
        return algorithmIdentifier == null || algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.id_hmacWithSHA1);
    }

    static boolean b(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return b.contains(aSN1ObjectIdentifier);
    }

    static boolean c(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return c.contains(aSN1ObjectIdentifier);
    }

    public static boolean d(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return aSN1ObjectIdentifier.getId().startsWith(PKCSObjectIdentifiers.pkcs_12PbeIds.getId());
    }

    public static SecretKey a(JcaJceHelper jcaJceHelper, String string, char[] cArray, byte[] byArray, int n2) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory secretKeyFactory = jcaJceHelper.createSecretKeyFactory("PBKDF2with8BIT");
        SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(cArray, byArray, n2, h.a(string)));
        return new SecretKeySpec(secretKey.getEncoded(), string);
    }

    public static SecretKey a(JcaJceHelper jcaJceHelper, String string, char[] cArray, byte[] byArray, int n2, AlgorithmIdentifier algorithmIdentifier) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        String string2 = (String)d.get(algorithmIdentifier.getAlgorithm());
        if (string2 == null) {
            throw new NoSuchAlgorithmException("unknown PRF in PKCS#2: " + algorithmIdentifier.getAlgorithm());
        }
        SecretKeyFactory secretKeyFactory = jcaJceHelper.createSecretKeyFactory(string2);
        SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(cArray, byArray, n2, h.a(string)));
        return new SecretKeySpec(secretKey.getEncoded(), string);
    }

    static byte[] a(boolean bl2, JcaJceHelper jcaJceHelper, byte[] byArray, char[] cArray, String string, byte[] byArray2) throws PEMException {
        SecretKey secretKey;
        String string2;
        AlgorithmParameterSpec algorithmParameterSpec = new IvParameterSpec(byArray2);
        String string3 = "CBC";
        String string4 = "PKCS5Padding";
        if (string.endsWith("-CFB")) {
            string3 = "CFB";
            string4 = "NoPadding";
        }
        if (string.endsWith("-ECB") || "DES-EDE".equals(string) || "DES-EDE3".equals(string)) {
            string3 = "ECB";
            algorithmParameterSpec = null;
        }
        if (string.endsWith("-OFB")) {
            string3 = "OFB";
            string4 = "NoPadding";
        }
        if (string.startsWith("DES-EDE")) {
            string2 = "DESede";
            boolean bl3 = !string.startsWith("DES-EDE3");
            secretKey = h.a(jcaJceHelper, cArray, string2, 24, byArray2, bl3);
        } else if (string.startsWith("DES-")) {
            string2 = "DES";
            secretKey = h.a(jcaJceHelper, cArray, string2, 8, byArray2);
        } else if (string.startsWith("BF-")) {
            string2 = "Blowfish";
            secretKey = h.a(jcaJceHelper, cArray, string2, 16, byArray2);
        } else if (string.startsWith("RC2-")) {
            string2 = "RC2";
            int n2 = 128;
            if (string.startsWith("RC2-40-")) {
                n2 = 40;
            } else if (string.startsWith("RC2-64-")) {
                n2 = 64;
            }
            secretKey = h.a(jcaJceHelper, cArray, string2, n2 / 8, byArray2);
            algorithmParameterSpec = algorithmParameterSpec == null ? new RC2ParameterSpec(n2) : new RC2ParameterSpec(n2, byArray2);
        } else if (string.startsWith("AES-")) {
            int n3;
            string2 = "AES";
            byte[] byArray3 = byArray2;
            if (byArray3.length > 8) {
                byArray3 = new byte[8];
                System.arraycopy(byArray2, 0, byArray3, 0, 8);
            }
            if (string.startsWith("AES-128-")) {
                n3 = 128;
            } else if (string.startsWith("AES-192-")) {
                n3 = 192;
            } else if (string.startsWith("AES-256-")) {
                n3 = 256;
            } else {
                throw new EncryptionException("unknown AES encryption with private key");
            }
            secretKey = h.a(jcaJceHelper, cArray, "AES", n3 / 8, byArray3);
        } else {
            throw new EncryptionException("unknown encryption with private key");
        }
        String string5 = string2 + "/" + string3 + "/" + string4;
        try {
            int n4;
            Cipher cipher = jcaJceHelper.createCipher(string5);
            int n5 = n4 = bl2 ? 1 : 2;
            if (algorithmParameterSpec == null) {
                cipher.init(n4, secretKey);
            } else {
                cipher.init(n4, (Key)secretKey, algorithmParameterSpec);
            }
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new EncryptionException("exception using cipher - please check password and data.", (Throwable)exception);
        }
    }

    private static SecretKey a(JcaJceHelper jcaJceHelper, char[] cArray, String string, int n2, byte[] byArray) throws PEMException {
        return h.a(jcaJceHelper, cArray, string, n2, byArray, false);
    }

    private static SecretKey a(JcaJceHelper jcaJceHelper, char[] cArray, String string, int n2, byte[] byArray, boolean bl2) throws PEMException {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, 1, n2 * 8);
            SecretKeyFactory secretKeyFactory = jcaJceHelper.createSecretKeyFactory("PBKDF-OpenSSL");
            byte[] byArray2 = secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
            if (bl2 && byArray2.length >= 24) {
                System.arraycopy(byArray2, 0, byArray2, 16, 8);
            }
            return new SecretKeySpec(byArray2, string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PEMException("Unable to create OpenSSL PBDKF: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    static {
        b.add(PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC);
        b.add(PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC);
        b.add(PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC);
        b.add(PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC);
        b.add(PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC);
        b.add(PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC);
        c.add(PKCSObjectIdentifiers.id_PBES2);
        c.add(PKCSObjectIdentifiers.des_EDE3_CBC);
        c.add(NISTObjectIdentifiers.id_aes128_CBC);
        c.add(NISTObjectIdentifiers.id_aes192_CBC);
        c.add(NISTObjectIdentifiers.id_aes256_CBC);
        a.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), Integers.valueOf(192));
        a.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), Integers.valueOf(128));
        a.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), Integers.valueOf(192));
        a.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), Integers.valueOf(256));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4.getId(), Integers.valueOf(128));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4, Integers.valueOf(40));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC, Integers.valueOf(128));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, Integers.valueOf(192));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC, Integers.valueOf(128));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, Integers.valueOf(40));
        d.put(PKCSObjectIdentifiers.id_hmacWithSHA1, "PBKDF2withHMACSHA1");
        d.put(PKCSObjectIdentifiers.id_hmacWithSHA256, "PBKDF2withHMACSHA256");
        d.put(PKCSObjectIdentifiers.id_hmacWithSHA512, "PBKDF2withHMACSHA512");
        d.put(PKCSObjectIdentifiers.id_hmacWithSHA224, "PBKDF2withHMACSHA224");
        d.put(PKCSObjectIdentifiers.id_hmacWithSHA384, "PBKDF2withHMACSHA384");
        d.put(NISTObjectIdentifiers.id_hmacWithSHA3_224, "PBKDF2withHMACSHA3-224");
        d.put(NISTObjectIdentifiers.id_hmacWithSHA3_256, "PBKDF2withHMACSHA3-256");
        d.put(NISTObjectIdentifiers.id_hmacWithSHA3_384, "PBKDF2withHMACSHA3-384");
        d.put(NISTObjectIdentifiers.id_hmacWithSHA3_512, "PBKDF2withHMACSHA3-512");
        d.put(CryptoProObjectIdentifiers.gostR3411Hmac, "PBKDF2withHMACGOST3411");
        e.put(PKCSObjectIdentifiers.id_hmacWithSHA1, Integers.valueOf(20));
        e.put(PKCSObjectIdentifiers.id_hmacWithSHA256, Integers.valueOf(32));
        e.put(PKCSObjectIdentifiers.id_hmacWithSHA512, Integers.valueOf(64));
        e.put(PKCSObjectIdentifiers.id_hmacWithSHA224, Integers.valueOf(28));
        e.put(PKCSObjectIdentifiers.id_hmacWithSHA384, Integers.valueOf(48));
        e.put(NISTObjectIdentifiers.id_hmacWithSHA3_224, Integers.valueOf(28));
        e.put(NISTObjectIdentifiers.id_hmacWithSHA3_256, Integers.valueOf(32));
        e.put(NISTObjectIdentifiers.id_hmacWithSHA3_384, Integers.valueOf(48));
        e.put(NISTObjectIdentifiers.id_hmacWithSHA3_512, Integers.valueOf(64));
        e.put(CryptoProObjectIdentifiers.gostR3411Hmac, Integers.valueOf(32));
    }
}

