/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.math.ec.custom.sec;

import com.aspose.cad.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.cad.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.cad.internal.bouncycastle.math.ec.ECLookupTable;
import com.aspose.cad.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.cad.internal.bouncycastle.math.ec.custom.sec.SecP192R1FieldElement;
import com.aspose.cad.internal.bouncycastle.math.ec.custom.sec.SecP192R1Point;
import com.aspose.cad.internal.bouncycastle.math.ec.custom.sec.f;
import com.aspose.cad.internal.bouncycastle.math.raw.Nat192;
import com.aspose.cad.internal.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP192R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF"));
    private static final int c = 2;
    protected SecP192R1Point infinity = new SecP192R1Point(this, null, null);

    public SecP192R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1")));
        this.order = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP192R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP192R1FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecP192R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecP192R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, int n3) {
        int[] nArray = new int[n3 * 6 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat192.copy(((SecP192R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n4);
            Nat192.copy(((SecP192R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n4 += 6);
            n4 += 6;
        }
        return new f(this, n3, nArray);
    }
}

