/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.Mac;
import com.aspose.cad.internal.bouncycastle.crypto.macs.HMac;
import com.aspose.cad.internal.bouncycastle.crypto.params.AEADParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.cad.internal.bouncycastle.crypto.params.RC2Parameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.SkeinParameters;
import com.aspose.cad.internal.bouncycastle.jcajce.PKCS12Key;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.aspose.cad.internal.bouncycastle.jcajce.spec.AEADParameterSpec;
import com.aspose.cad.internal.bouncycastle.jcajce.spec.SkeinParameterSpec;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class BaseMac
extends MacSpi
implements PBE {
    private static final Class a = ClassUtil.loadClass(BaseMac.class, "javax.crypto.spec.GCMParameterSpec");
    private Mac b;
    private int c = 2;
    private int d = 1;
    private int e = 160;

    protected BaseMac(Mac mac) {
        this.b = mac;
    }

    protected BaseMac(Mac mac, int n2, int n3, int n4) {
        this.b = mac;
        this.c = n2;
        this.d = n3;
        this.e = n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters cipherParameters;
        Object object;
        Object object2;
        if (key == null) {
            throw new InvalidKeyException("key is null");
        }
        if (key instanceof PKCS12Key) {
            try {
                object2 = (SecretKey)key;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("PKCS12 requires a SecretKey/PBEKey");
            }
            try {
                object = (PBEParameterSpec)algorithmParameterSpec;
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("PKCS12 requires a PBEParameterSpec");
            }
            if (object2 instanceof PBEKey && object == null) {
                object = new PBEParameterSpec(((PBEKey)object2).getSalt(), ((PBEKey)object2).getIterationCount());
            }
            int n2 = 1;
            int n3 = 160;
            if (this.b.getAlgorithmName().startsWith("GOST")) {
                n2 = 6;
                n3 = 256;
            } else if (this.b instanceof HMac && !this.b.getAlgorithmName().startsWith("SHA-1")) {
                if (this.b.getAlgorithmName().startsWith("SHA-224")) {
                    n2 = 7;
                    n3 = 224;
                } else if (this.b.getAlgorithmName().startsWith("SHA-256")) {
                    n2 = 4;
                    n3 = 256;
                } else if (this.b.getAlgorithmName().startsWith("SHA-384")) {
                    n2 = 8;
                    n3 = 384;
                } else if (this.b.getAlgorithmName().startsWith("SHA-512")) {
                    n2 = 9;
                    n3 = 512;
                } else {
                    if (!this.b.getAlgorithmName().startsWith("RIPEMD160")) throw new InvalidAlgorithmParameterException("no PKCS12 mapping for HMAC: " + this.b.getAlgorithmName());
                    n2 = 2;
                    n3 = 160;
                }
            }
            cipherParameters = PBE.Util.makePBEMacParameters((SecretKey)object2, 2, n2, n3, (PBEParameterSpec)object);
        } else if (key instanceof BCPBEKey) {
            object2 = (BCPBEKey)key;
            if (((BCPBEKey)object2).getParam() != null) {
                cipherParameters = ((BCPBEKey)object2).getParam();
            } else {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                cipherParameters = PBE.Util.makePBEMacParameters((BCPBEKey)object2, algorithmParameterSpec);
            }
        } else {
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                throw new InvalidAlgorithmParameterException("inappropriate parameter type: " + algorithmParameterSpec.getClass().getName());
            }
            cipherParameters = new KeyParameter(key.getEncoded());
        }
        object2 = cipherParameters instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)cipherParameters).getParameters() : (KeyParameter)cipherParameters;
        if (algorithmParameterSpec instanceof AEADParameterSpec) {
            object = (AEADParameterSpec)algorithmParameterSpec;
            cipherParameters = new AEADParameters((KeyParameter)object2, ((AEADParameterSpec)object).getMacSizeInBits(), ((AEADParameterSpec)object).getNonce(), ((AEADParameterSpec)object).getAssociatedData());
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            cipherParameters = new ParametersWithIV((CipherParameters)object2, ((IvParameterSpec)algorithmParameterSpec).getIV());
        } else if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            cipherParameters = new ParametersWithIV(new RC2Parameters(((KeyParameter)object2).getKey(), ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits()), ((RC2ParameterSpec)algorithmParameterSpec).getIV());
        } else if (algorithmParameterSpec instanceof SkeinParameterSpec) {
            cipherParameters = new SkeinParameters.Builder(BaseMac.a(((SkeinParameterSpec)algorithmParameterSpec).getParameters())).setKey(((KeyParameter)object2).getKey()).build();
        } else if (algorithmParameterSpec == null) {
            cipherParameters = new KeyParameter(key.getEncoded());
        } else if (a != null && a.isAssignableFrom(algorithmParameterSpec.getClass())) {
            try {
                object = a.getDeclaredMethod("getTLen", new Class[0]);
                Method method = a.getDeclaredMethod("getIV", new Class[0]);
                cipherParameters = new AEADParameters((KeyParameter)object2, (Integer)((Method)object).invoke((Object)algorithmParameterSpec, new Object[0]), (byte[])method.invoke((Object)algorithmParameterSpec, new Object[0]));
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("Cannot process GCMParameterSpec.");
            }
        } else if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unknown parameter type: " + algorithmParameterSpec.getClass().getName());
        }
        try {
            this.b.init(cipherParameters);
            return;
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException("cannot initialize MAC: " + exception.getMessage());
        }
    }

    @Override
    protected int engineGetMacLength() {
        return this.b.getMacSize();
    }

    @Override
    protected void engineReset() {
        this.b.reset();
    }

    @Override
    protected void engineUpdate(byte by2) {
        this.b.update(by2);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.b.update(byArray, n2, n3);
    }

    @Override
    protected byte[] engineDoFinal() {
        byte[] byArray = new byte[this.engineGetMacLength()];
        this.b.doFinal(byArray, 0);
        return byArray;
    }

    private static Hashtable a(Map map) {
        Hashtable hashtable = new Hashtable();
        for (Object k2 : map.keySet()) {
            hashtable.put(k2, map.get(k2));
        }
        return hashtable;
    }
}

