/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric;

import com.aspose.cad.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.engines.TwofishEngine;
import com.aspose.cad.internal.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.macs.GMac;
import com.aspose.cad.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.modes.GCMBlockCipher;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.p;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.q;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.PBESecretKeyFactory;

public final class Twofish {
    private Twofish() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Twofish IV";
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new q());
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new TwofishEngine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Twofish", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends p {
        private static final String a = Twofish.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.Twofish", a + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.Twofish", a + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.Twofish", a + "$AlgParams");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH-CBC", "PKCS12PBE");
            configurableProvider.addAlgorithm("Cipher.PBEWITHSHAANDTWOFISH-CBC", a + "$PBEWithSHA");
            configurableProvider.addAlgorithm("SecretKeyFactory.PBEWITHSHAANDTWOFISH-CBC", a + "$PBEWithSHAKeyFactory");
            this.addGMacAlgorithm(configurableProvider, "Twofish", a + "$GMAC", a + "$KeyGen");
            this.addPoly1305Algorithm(configurableProvider, "Twofish", a + "$Poly1305", a + "$Poly1305KeyGen");
        }
    }

    public static class PBEWithSHA
    extends BaseBlockCipher {
        public PBEWithSHA() {
            super(new CBCBlockCipher(new TwofishEngine()), 2, 1, 256, 16);
        }
    }

    public static class PBEWithSHAKeyFactory
    extends PBESecretKeyFactory {
        public PBEWithSHAKeyFactory() {
            super("PBEwithSHAandTwofish-CBC", null, true, 2, 1, 256, 128);
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new com.aspose.cad.internal.bouncycastle.crypto.macs.Poly1305(new TwofishEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-Twofish", 256, new Poly1305KeyGenerator());
        }
    }
}

