/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.dvcs;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import com.aspose.cad.internal.bouncycastle.asn1.dvcs.Data;
import com.aspose.cad.internal.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralNames;
import com.aspose.cad.internal.bouncycastle.cms.CMSSignedDataGenerator;
import com.aspose.cad.internal.bouncycastle.dvcs.DVCSException;
import com.aspose.cad.internal.bouncycastle.dvcs.DVCSRequest;
import java.io.IOException;
import java.math.BigInteger;

public abstract class DVCSRequestBuilder {
    private final ExtensionsGenerator a = new ExtensionsGenerator();
    private final CMSSignedDataGenerator b = new CMSSignedDataGenerator();
    protected final DVCSRequestInformationBuilder requestInformationBuilder;

    protected DVCSRequestBuilder(DVCSRequestInformationBuilder dVCSRequestInformationBuilder) {
        this.requestInformationBuilder = dVCSRequestInformationBuilder;
    }

    public void setNonce(BigInteger bigInteger) {
        this.requestInformationBuilder.setNonce(bigInteger);
    }

    public void setRequester(GeneralName generalName) {
        this.requestInformationBuilder.setRequester(generalName);
    }

    public void setDVCS(GeneralName generalName) {
        this.requestInformationBuilder.setDVCS(generalName);
    }

    public void setDVCS(GeneralNames generalNames) {
        this.requestInformationBuilder.setDVCS(generalNames);
    }

    public void setDataLocations(GeneralName generalName) {
        this.requestInformationBuilder.setDataLocations(generalName);
    }

    public void setDataLocations(GeneralNames generalNames) {
        this.requestInformationBuilder.setDataLocations(generalNames);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) throws DVCSException {
        try {
            this.a.addExtension(aSN1ObjectIdentifier, bl2, aSN1Encodable);
        }
        catch (IOException iOException) {
            throw new DVCSException("cannot encode extension: " + iOException.getMessage(), iOException);
        }
    }

    protected DVCSRequest createDVCRequest(Data data) throws DVCSException {
        if (!this.a.isEmpty()) {
            this.requestInformationBuilder.setExtensions(this.a.generate());
        }
        com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSRequest dVCSRequest = new com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSRequest(this.requestInformationBuilder.build(), data);
        return new DVCSRequest(new ContentInfo(DVCSObjectIdentifiers.id_ct_DVCSRequestData, dVCSRequest));
    }
}

