/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.modes;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.BufferedBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.modes.CBCBlockCipher;

public class NISTCTSBlockCipher
extends BufferedBlockCipher {
    public static final int CS1 = 1;
    public static final int CS2 = 2;
    public static final int CS3 = 3;
    private final int a;
    private final int b;

    public NISTCTSBlockCipher(int n2, BlockCipher blockCipher) {
        this.a = n2;
        this.cipher = new CBCBlockCipher(blockCipher);
        this.b = blockCipher.getBlockSize();
        this.buf = new byte[this.b * 2];
        this.bufOff = 0;
    }

    @Override
    public int getUpdateOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        int n4 = n3 % this.buf.length;
        if (n4 == 0) {
            return n3 - this.buf.length;
        }
        return n3 - n4;
    }

    @Override
    public int getOutputSize(int n2) {
        return n2 + this.bufOff;
    }

    @Override
    public int processByte(byte by2, byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        int n3 = 0;
        if (this.bufOff == this.buf.length) {
            n3 = this.cipher.processBlock(this.buf, 0, byArray, n2);
            System.arraycopy(this.buf, this.b, this.buf, 0, this.b);
            this.bufOff = this.b;
        }
        this.buf[this.bufOff++] = by2;
        return n3;
    }

    @Override
    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException, IllegalStateException {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n5 = this.getBlockSize();
        int n6 = this.getUpdateOutputSize(n3);
        if (n6 > 0 && n4 + n6 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n7 = 0;
        int n8 = this.buf.length - this.bufOff;
        if (n3 > n8) {
            System.arraycopy(byArray, n2, this.buf, this.bufOff, n8);
            n7 += this.cipher.processBlock(this.buf, 0, byArray2, n4);
            System.arraycopy(this.buf, n5, this.buf, 0, n5);
            this.bufOff = n5;
            n3 -= n8;
            n2 += n8;
            while (n3 > n5) {
                System.arraycopy(byArray, n2, this.buf, this.bufOff, n5);
                n7 += this.cipher.processBlock(this.buf, 0, byArray2, n4 + n7);
                System.arraycopy(this.buf, n5, this.buf, 0, n5);
                n3 -= n5;
                n2 += n5;
            }
        }
        System.arraycopy(byArray, n2, this.buf, this.bufOff, n3);
        this.bufOff += n3;
        return n7;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        byte[] byArray2;
        if (this.bufOff + n2 > byArray.length) {
            throw new OutputLengthException("output buffer to small in doFinal");
        }
        int n3 = this.cipher.getBlockSize();
        int n4 = this.bufOff - n3;
        byte[] byArray3 = new byte[n3];
        if (this.forEncryption) {
            if (this.bufOff < n3) {
                throw new DataLengthException("need at least one block of input for NISTCTS");
            }
            if (this.bufOff > n3) {
                byArray2 = new byte[n3];
                if (this.a == 2 || this.a == 3) {
                    this.cipher.processBlock(this.buf, 0, byArray3, 0);
                    System.arraycopy(this.buf, n3, byArray2, 0, n4);
                    this.cipher.processBlock(byArray2, 0, byArray2, 0);
                    if (this.a == 2 && n4 == n3) {
                        System.arraycopy(byArray3, 0, byArray, n2, n3);
                        System.arraycopy(byArray2, 0, byArray, n2 + n3, n4);
                    } else {
                        System.arraycopy(byArray2, 0, byArray, n2, n3);
                        System.arraycopy(byArray3, 0, byArray, n2 + n3, n4);
                    }
                } else {
                    System.arraycopy(this.buf, 0, byArray3, 0, n3);
                    this.cipher.processBlock(byArray3, 0, byArray3, 0);
                    System.arraycopy(byArray3, 0, byArray, n2, n4);
                    System.arraycopy(this.buf, this.bufOff - n4, byArray2, 0, n4);
                    this.cipher.processBlock(byArray2, 0, byArray2, 0);
                    System.arraycopy(byArray2, 0, byArray, n2 + n4, n3);
                }
            } else {
                this.cipher.processBlock(this.buf, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray, n2, n3);
            }
        } else {
            if (this.bufOff < n3) {
                throw new DataLengthException("need at least one block of input for CTS");
            }
            byArray2 = new byte[n3];
            if (this.bufOff > n3) {
                if (this.a == 3 || this.a == 2 && (this.buf.length - this.bufOff) % n3 != 0) {
                    if (this.cipher instanceof CBCBlockCipher) {
                        BlockCipher blockCipher = ((CBCBlockCipher)this.cipher).getUnderlyingCipher();
                        blockCipher.processBlock(this.buf, 0, byArray3, 0);
                    } else {
                        this.cipher.processBlock(this.buf, 0, byArray3, 0);
                    }
                    for (int i2 = n3; i2 != this.bufOff; ++i2) {
                        byArray2[i2 - n3] = (byte)(byArray3[i2 - n3] ^ this.buf[i2]);
                    }
                    System.arraycopy(this.buf, n3, byArray3, 0, n4);
                    this.cipher.processBlock(byArray3, 0, byArray, n2);
                    System.arraycopy(byArray2, 0, byArray, n2 + n3, n4);
                } else {
                    BlockCipher blockCipher = ((CBCBlockCipher)this.cipher).getUnderlyingCipher();
                    blockCipher.processBlock(this.buf, this.bufOff - n3, byArray2, 0);
                    System.arraycopy(this.buf, 0, byArray3, 0, n3);
                    if (n4 != n3) {
                        System.arraycopy(byArray2, n4, byArray3, n4, n3 - n4);
                    }
                    this.cipher.processBlock(byArray3, 0, byArray3, 0);
                    System.arraycopy(byArray3, 0, byArray, n2, n3);
                    for (int i3 = 0; i3 != n4; ++i3) {
                        int n5 = i3;
                        byArray2[n5] = (byte)(byArray2[n5] ^ this.buf[i3]);
                    }
                    System.arraycopy(byArray2, 0, byArray, n2 + n3, n4);
                }
            } else {
                this.cipher.processBlock(this.buf, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray, n2, n3);
            }
        }
        int n6 = this.bufOff;
        this.reset();
        return n6;
    }
}

