/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.macs;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.Mac;
import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.digests.DSTU7564Digest;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.util.Pack;

public class DSTU7564Mac
implements Mac {
    private static final int a = 8;
    private DSTU7564Digest b;
    private int c;
    private byte[] d;
    private byte[] e;
    private long f;

    public DSTU7564Mac(int n2) {
        this.b = new DSTU7564Digest(n2);
        this.c = n2 / 8;
        this.d = null;
        this.e = null;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters instanceof KeyParameter) {
            byte[] byArray = ((KeyParameter)cipherParameters).getKey();
            this.e = new byte[byArray.length];
            this.d = this.a(byArray);
            for (int i2 = 0; i2 < this.e.length; ++i2) {
                this.e[i2] = ~byArray[i2];
            }
        } else {
            throw new IllegalArgumentException("Bad parameter passed");
        }
        this.b.update(this.d, 0, this.d.length);
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7564Mac";
    }

    @Override
    public int getMacSize() {
        return this.c;
    }

    @Override
    public void update(byte by2) throws IllegalStateException {
        this.b.update(by2);
        ++this.f;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalStateException {
        if (byArray.length - n2 < n3) {
            throw new DataLengthException("Input buffer too short");
        }
        if (this.d == null) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        this.b.update(byArray, n2, n3);
        this.f += (long)n3;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        if (this.d == null) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (byArray.length - n2 < this.c) {
            throw new OutputLengthException("Output buffer too short");
        }
        this.a();
        this.b.update(this.e, 0, this.e.length);
        this.f = 0L;
        return this.b.doFinal(byArray, n2);
    }

    @Override
    public void reset() {
        this.f = 0L;
        this.b.reset();
        if (this.d != null) {
            this.b.update(this.d, 0, this.d.length);
        }
    }

    private void a() {
        int n2 = this.b.getByteLength() - (int)(this.f % (long)this.b.getByteLength());
        if (n2 < 13) {
            n2 += this.b.getByteLength();
        }
        byte[] byArray = new byte[n2];
        byArray[0] = -128;
        Pack.longToLittleEndian(this.f * 8L, byArray, byArray.length - 12);
        this.b.update(byArray, 0, byArray.length);
    }

    private byte[] a(byte[] byArray) {
        int n2 = (byArray.length + this.b.getByteLength() - 1) / this.b.getByteLength() * this.b.getByteLength();
        int n3 = this.b.getByteLength() - byArray.length % this.b.getByteLength();
        if (n3 < 13) {
            n2 += this.b.getByteLength();
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = -128;
        Pack.intToLittleEndian(byArray.length * 8, byArray2, byArray2.length - 12);
        return byArray2;
    }
}

