/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.macs;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.Mac;
import com.aspose.cad.internal.bouncycastle.crypto.macs.a;
import com.aspose.cad.internal.bouncycastle.crypto.paddings.BlockCipherPadding;

public class CFBBlockCipherMac
implements Mac {
    private byte[] a;
    private byte[] b;
    private int c;
    private a d;
    private BlockCipherPadding e = null;
    private int f;

    public CFBBlockCipherMac(BlockCipher blockCipher) {
        this(blockCipher, 8, blockCipher.getBlockSize() * 8 / 2, null);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        this(blockCipher, 8, blockCipher.getBlockSize() * 8 / 2, blockCipherPadding);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, int n2, int n3) {
        this(blockCipher, n2, n3, null);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, int n2, int n3, BlockCipherPadding blockCipherPadding) {
        if (n3 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        this.a = new byte[blockCipher.getBlockSize()];
        this.d = new a(blockCipher, n2);
        this.e = blockCipherPadding;
        this.f = n3 / 8;
        this.b = new byte[this.d.b()];
        this.c = 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.d.a();
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.reset();
        this.d.a(cipherParameters);
    }

    @Override
    public int getMacSize() {
        return this.f;
    }

    @Override
    public void update(byte by2) {
        if (this.c == this.b.length) {
            this.d.a(this.b, 0, this.a, 0);
            this.c = 0;
        }
        this.b[this.c++] = by2;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.d.b();
        int n5 = 0;
        int n6 = n4 - this.c;
        if (n3 > n6) {
            System.arraycopy(byArray, n2, this.b, this.c, n6);
            n5 += this.d.a(this.b, 0, this.a, 0);
            this.c = 0;
            n3 -= n6;
            n2 += n6;
            while (n3 > n4) {
                n5 += this.d.a(byArray, n2, this.a, 0);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.b, this.c, n3);
        this.c += n3;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        int n3 = this.d.b();
        if (this.e == null) {
            while (this.c < n3) {
                this.b[this.c] = 0;
                ++this.c;
            }
        } else {
            this.e.addPadding(this.b, this.c);
        }
        this.d.a(this.b, 0, this.a, 0);
        this.d.a(this.a);
        System.arraycopy(this.a, 0, byArray, n2, this.f);
        this.reset();
        return this.f;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2] = 0;
        }
        this.c = 0;
        this.d.c();
    }
}

