/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.engines;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.digests.SM3Digest;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.cad.internal.bouncycastle.math.ec.ECConstants;
import com.aspose.cad.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.cad.internal.bouncycastle.math.ec.ECMultiplier;
import com.aspose.cad.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.cad.internal.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.BigIntegers;
import com.aspose.cad.internal.bouncycastle.util.Memoable;
import com.aspose.cad.internal.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2Engine {
    private final Digest a;
    private boolean b;
    private ECKeyParameters c;
    private ECDomainParameters d;
    private int e;
    private SecureRandom f;

    public SM2Engine() {
        this(new SM3Digest());
    }

    public SM2Engine(Digest digest) {
        this.a = digest;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.b = bl2;
        if (bl2) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.c = (ECKeyParameters)parametersWithRandom.getParameters();
            this.d = this.c.getParameters();
            ECPoint eCPoint = ((ECPublicKeyParameters)this.c).getQ().multiply(this.d.getH());
            if (eCPoint.isInfinity()) {
                throw new IllegalArgumentException("invalid key: [h]Q at infinity");
            }
            this.f = parametersWithRandom.getRandom();
        } else {
            this.c = (ECKeyParameters)cipherParameters;
            this.d = this.c.getParameters();
        }
        this.e = (this.d.getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] processBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.b) {
            return this.a(byArray, n2, n3);
        }
        return this.b(byArray, n2, n3);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    private byte[] a(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        ECPoint eCPoint;
        byte[] byArray2;
        Object object;
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2, byArray3, 0, byArray3.length);
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        do {
            object = this.a();
            ECPoint eCPoint2 = eCMultiplier.multiply(this.d.getG(), (BigInteger)object).normalize();
            byArray2 = eCPoint2.getEncoded(false);
            eCPoint = ((ECPublicKeyParameters)this.c).getQ().multiply((BigInteger)object).normalize();
            this.a(this.a, eCPoint, byArray3);
        } while (this.a(byArray3, byArray, n2));
        object = new byte[this.a.getDigestSize()];
        this.a(this.a, eCPoint.getAffineXCoord());
        this.a.update(byArray, n2, n3);
        this.a(this.a, eCPoint.getAffineYCoord());
        this.a.doFinal((byte[])object, 0);
        return Arrays.concatenate(byArray2, byArray3, (byte[])object);
    }

    private byte[] b(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2 = new byte[this.e * 2 + 1];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        ECPoint eCPoint = this.d.getCurve().decodePoint(byArray2);
        ECPoint eCPoint2 = eCPoint.multiply(this.d.getH());
        if (eCPoint2.isInfinity()) {
            throw new InvalidCipherTextException("[h]C1 at infinity");
        }
        eCPoint = eCPoint.multiply(((ECPrivateKeyParameters)this.c).getD()).normalize();
        byte[] byArray3 = new byte[n3 - byArray2.length - this.a.getDigestSize()];
        System.arraycopy(byArray, n2 + byArray2.length, byArray3, 0, byArray3.length);
        this.a(this.a, eCPoint, byArray3);
        byte[] byArray4 = new byte[this.a.getDigestSize()];
        this.a(this.a, eCPoint.getAffineXCoord());
        this.a.update(byArray3, 0, byArray3.length);
        this.a(this.a, eCPoint.getAffineYCoord());
        this.a.doFinal(byArray4, 0);
        int n4 = 0;
        for (int i2 = 0; i2 != byArray4.length; ++i2) {
            n4 |= byArray4[i2] ^ byArray[byArray2.length + byArray3.length + i2];
        }
        Arrays.fill(byArray2, (byte)0);
        Arrays.fill(byArray4, (byte)0);
        if (n4 != 0) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("invalid cipher text");
        }
        return byArray3;
    }

    private boolean a(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            if (byArray[i2] == byArray2[n2]) continue;
            return false;
        }
        return true;
    }

    private void a(Digest digest, ECPoint eCPoint, byte[] byArray) {
        int n2 = digest.getDigestSize();
        byte[] byArray2 = new byte[Math.max(4, n2)];
        int n3 = 0;
        Memoable memoable = null;
        Memoable memoable2 = null;
        if (digest instanceof Memoable) {
            this.a(digest, eCPoint.getAffineXCoord());
            this.a(digest, eCPoint.getAffineYCoord());
            memoable = (Memoable)((Object)digest);
            memoable2 = memoable.copy();
        }
        int n4 = 0;
        while (n3 < byArray.length) {
            if (memoable != null) {
                memoable.reset(memoable2);
            } else {
                this.a(digest, eCPoint.getAffineXCoord());
                this.a(digest, eCPoint.getAffineYCoord());
            }
            Pack.intToBigEndian(++n4, byArray2, 0);
            digest.update(byArray2, 0, 4);
            digest.doFinal(byArray2, 0);
            int n5 = Math.min(n2, byArray.length - n3);
            this.a(byArray, byArray2, n3, n5);
            n3 += n5;
        }
    }

    private void a(byte[] byArray, byte[] byArray2, int n2, int n3) {
        for (int i2 = 0; i2 != n3; ++i2) {
            int n4 = n2 + i2;
            byArray[n4] = (byte)(byArray[n4] ^ byArray2[i2]);
        }
    }

    private BigInteger a() {
        BigInteger bigInteger;
        int n2 = this.d.getN().bitLength();
        while ((bigInteger = new BigInteger(n2, this.f)).equals(ECConstants.ZERO) || bigInteger.compareTo(this.d.getN()) >= 0) {
        }
        return bigInteger;
    }

    private void a(Digest digest, ECFieldElement eCFieldElement) {
        byte[] byArray = BigIntegers.asUnsignedByteArray(this.e, eCFieldElement.toBigInteger());
        digest.update(byArray, 0, byArray.length);
    }
}

