/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import com.aspose.cad.internal.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import com.aspose.cad.internal.bouncycastle.asn1.cms.OriginatorPublicKey;
import com.aspose.cad.internal.bouncycastle.asn1.cms.RecipientInfo;
import com.aspose.cad.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.cryptopro.Gost2814789KeyWrapParameters;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.cms.CMSException;
import com.aspose.cad.internal.bouncycastle.cms.RecipientInfoGenerator;
import com.aspose.cad.internal.bouncycastle.cms.o;
import com.aspose.cad.internal.bouncycastle.operator.GenericKey;

public abstract class KeyAgreeRecipientInfoGenerator
implements RecipientInfoGenerator {
    private ASN1ObjectIdentifier a;
    private ASN1ObjectIdentifier b;
    private SubjectPublicKeyInfo c;

    protected KeyAgreeRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1ObjectIdentifier aSN1ObjectIdentifier2) {
        this.c = subjectPublicKeyInfo;
        this.a = aSN1ObjectIdentifier;
        this.b = aSN1ObjectIdentifier2;
    }

    @Override
    public RecipientInfo generate(GenericKey genericKey) throws CMSException {
        OriginatorIdentifierOrKey originatorIdentifierOrKey = new OriginatorIdentifierOrKey(this.createOriginatorPublicKey(this.c));
        AlgorithmIdentifier algorithmIdentifier = o.a(this.b.getId()) || this.b.equals(PKCSObjectIdentifiers.id_alg_CMSRC2wrap) ? new AlgorithmIdentifier(this.b, DERNull.INSTANCE) : (o.c(this.a) ? new AlgorithmIdentifier(this.b, new Gost2814789KeyWrapParameters(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet)) : new AlgorithmIdentifier(this.b));
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(this.a, algorithmIdentifier);
        ASN1Sequence aSN1Sequence = this.generateRecipientEncryptedKeys(algorithmIdentifier2, algorithmIdentifier, genericKey);
        byte[] byArray = this.getUserKeyingMaterial(algorithmIdentifier2);
        if (byArray != null) {
            return new RecipientInfo(new KeyAgreeRecipientInfo(originatorIdentifierOrKey, new DEROctetString(byArray), algorithmIdentifier2, aSN1Sequence));
        }
        return new RecipientInfo(new KeyAgreeRecipientInfo(originatorIdentifierOrKey, null, algorithmIdentifier2, aSN1Sequence));
    }

    protected OriginatorPublicKey createOriginatorPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new OriginatorPublicKey(new AlgorithmIdentifier(subjectPublicKeyInfo.getAlgorithm().getAlgorithm(), DERNull.INSTANCE), subjectPublicKeyInfo.getPublicKeyData().getBytes());
    }

    protected abstract ASN1Sequence generateRecipientEncryptedKeys(AlgorithmIdentifier var1, AlgorithmIdentifier var2, GenericKey var3) throws CMSException;

    protected abstract byte[] getUserKeyingMaterial(AlgorithmIdentifier var1) throws CMSException;
}

