/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert.dane;

import com.aspose.cad.internal.bouncycastle.cert.dane.DANEEntrySelector;
import com.aspose.cad.internal.bouncycastle.cert.dane.DANEException;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.cad.internal.bouncycastle.util.Strings;
import com.aspose.cad.internal.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.io.OutputStream;

public class DANEEntrySelectorFactory {
    private final DigestCalculator a;

    public DANEEntrySelectorFactory(DigestCalculator digestCalculator) {
        this.a = digestCalculator;
    }

    public DANEEntrySelector createSelector(String string) throws DANEException {
        Object object;
        byte[] byArray = Strings.toUTF8ByteArray(string.substring(0, string.indexOf(64)));
        try {
            object = this.a.getOutputStream();
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new DANEException("Unable to calculate digest string: " + iOException.getMessage(), iOException);
        }
        object = this.a.getDigest();
        String string2 = Strings.fromByteArray(Hex.encode((byte[])object)) + "._smimecert." + string.substring(string.indexOf(64) + 1);
        return new DANEEntrySelector(string2);
    }
}

