/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.x9;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERBitString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9FieldElement;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9FieldID;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.math.ec.ECAlgorithms;
import com.aspose.cad.internal.bouncycastle.math.ec.ECCurve;
import java.math.BigInteger;

public class X9Curve
extends ASN1Object
implements X9ObjectIdentifiers {
    private ECCurve a;
    private byte[] b;
    private ASN1ObjectIdentifier c = null;

    public X9Curve(ECCurve eCCurve) {
        this.a = eCCurve;
        this.b = null;
        this.a();
    }

    public X9Curve(ECCurve eCCurve, byte[] byArray) {
        this.a = eCCurve;
        this.b = byArray;
        this.a();
    }

    public X9Curve(X9FieldID x9FieldID, ASN1Sequence aSN1Sequence) {
        this.c = x9FieldID.getIdentifier();
        if (this.c.equals(prime_field)) {
            BigInteger bigInteger = ((ASN1Integer)x9FieldID.getParameters()).getValue();
            X9FieldElement x9FieldElement = new X9FieldElement(bigInteger, (ASN1OctetString)aSN1Sequence.getObjectAt(0));
            X9FieldElement x9FieldElement2 = new X9FieldElement(bigInteger, (ASN1OctetString)aSN1Sequence.getObjectAt(1));
            this.a = new ECCurve.Fp(bigInteger, x9FieldElement.getValue().toBigInteger(), x9FieldElement2.getValue().toBigInteger());
        } else if (this.c.equals(characteristic_two_field)) {
            ASN1Object aSN1Object;
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(x9FieldID.getParameters());
            int n2 = ((ASN1Integer)aSN1Sequence2.getObjectAt(0)).getValue().intValue();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(1);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (aSN1ObjectIdentifier.equals(tpBasis)) {
                n3 = ASN1Integer.getInstance(aSN1Sequence2.getObjectAt(2)).getValue().intValue();
            } else if (aSN1ObjectIdentifier.equals(ppBasis)) {
                aSN1Object = ASN1Sequence.getInstance(aSN1Sequence2.getObjectAt(2));
                n3 = ASN1Integer.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(0)).getValue().intValue();
                n4 = ASN1Integer.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(1)).getValue().intValue();
                n5 = ASN1Integer.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(2)).getValue().intValue();
            } else {
                throw new IllegalArgumentException("This type of EC basis is not implemented");
            }
            aSN1Object = new X9FieldElement(n2, n3, n4, n5, (ASN1OctetString)aSN1Sequence.getObjectAt(0));
            X9FieldElement x9FieldElement = new X9FieldElement(n2, n3, n4, n5, (ASN1OctetString)aSN1Sequence.getObjectAt(1));
            this.a = new ECCurve.F2m(n2, n3, n4, n5, ((X9FieldElement)aSN1Object).getValue().toBigInteger(), x9FieldElement.getValue().toBigInteger());
        } else {
            throw new IllegalArgumentException("This type of ECCurve is not implemented");
        }
        if (aSN1Sequence.size() == 3) {
            this.b = ((DERBitString)aSN1Sequence.getObjectAt(2)).getBytes();
        }
    }

    private void a() {
        if (ECAlgorithms.isFpCurve(this.a)) {
            this.c = prime_field;
        } else if (ECAlgorithms.isF2mCurve(this.a)) {
            this.c = characteristic_two_field;
        } else {
            throw new IllegalArgumentException("This type of ECCurve is not implemented");
        }
    }

    public ECCurve getCurve() {
        return this.a;
    }

    public byte[] getSeed() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.c.equals(prime_field)) {
            aSN1EncodableVector.add(new X9FieldElement(this.a.getA()).toASN1Primitive());
            aSN1EncodableVector.add(new X9FieldElement(this.a.getB()).toASN1Primitive());
        } else if (this.c.equals(characteristic_two_field)) {
            aSN1EncodableVector.add(new X9FieldElement(this.a.getA()).toASN1Primitive());
            aSN1EncodableVector.add(new X9FieldElement(this.a.getB()).toASN1Primitive());
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERBitString(this.b));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

