/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.x509.sigi;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERPrintableString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.x500.DirectoryString;
import com.aspose.cad.internal.bouncycastle.asn1.x509.sigi.NameOrPseudonym;
import java.math.BigInteger;
import java.util.Enumeration;

public class PersonalData
extends ASN1Object {
    private NameOrPseudonym a;
    private BigInteger b;
    private ASN1GeneralizedTime c;
    private DirectoryString d;
    private String e;
    private DirectoryString f;

    public static PersonalData getInstance(Object object) {
        if (object == null || object instanceof PersonalData) {
            return (PersonalData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new PersonalData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    private PersonalData(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = NameOrPseudonym.getInstance(enumeration.nextElement());
        block7: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
            int n2 = aSN1TaggedObject.getTagNo();
            switch (n2) {
                case 0: {
                    this.b = ASN1Integer.getInstance(aSN1TaggedObject, false).getValue();
                    continue block7;
                }
                case 1: {
                    this.c = ASN1GeneralizedTime.getInstance(aSN1TaggedObject, false);
                    continue block7;
                }
                case 2: {
                    this.d = DirectoryString.getInstance(aSN1TaggedObject, true);
                    continue block7;
                }
                case 3: {
                    this.e = DERPrintableString.getInstance(aSN1TaggedObject, false).getString();
                    continue block7;
                }
                case 4: {
                    this.f = DirectoryString.getInstance(aSN1TaggedObject, true);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Bad tag number: " + aSN1TaggedObject.getTagNo());
        }
    }

    public PersonalData(NameOrPseudonym nameOrPseudonym, BigInteger bigInteger, ASN1GeneralizedTime aSN1GeneralizedTime, DirectoryString directoryString, String string, DirectoryString directoryString2) {
        this.a = nameOrPseudonym;
        this.c = aSN1GeneralizedTime;
        this.e = string;
        this.b = bigInteger;
        this.f = directoryString2;
        this.d = directoryString;
    }

    public NameOrPseudonym getNameOrPseudonym() {
        return this.a;
    }

    public BigInteger getNameDistinguisher() {
        return this.b;
    }

    public ASN1GeneralizedTime getDateOfBirth() {
        return this.c;
    }

    public DirectoryString getPlaceOfBirth() {
        return this.d;
    }

    public String getGender() {
        return this.e;
    }

    public DirectoryString getPostalAddress() {
        return this.f;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, new ASN1Integer(this.b)));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.c));
        }
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, this.d));
        }
        if (this.e != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 3, new DERPrintableString(this.e, true)));
        }
        if (this.f != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 4, this.f));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

