/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.dvcs;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSRequestInformation;
import com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSTime;
import com.aspose.cad.internal.bouncycastle.asn1.dvcs.ServiceType;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralNames;
import com.aspose.cad.internal.bouncycastle.asn1.x509.PolicyInformation;
import com.aspose.cad.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DVCSRequestInformationBuilder {
    private int a = 1;
    private final ServiceType b;
    private DVCSRequestInformation c;
    private BigInteger d;
    private DVCSTime e;
    private GeneralNames f;
    private PolicyInformation g;
    private GeneralNames h;
    private GeneralNames i;
    private Extensions j;
    private static final int k = 1;
    private static final int l = 0;
    private static final int m = 1;
    private static final int n = 2;
    private static final int o = 3;
    private static final int p = 4;

    public DVCSRequestInformationBuilder(ServiceType serviceType) {
        this.b = serviceType;
    }

    public DVCSRequestInformationBuilder(DVCSRequestInformation dVCSRequestInformation) {
        this.c = dVCSRequestInformation;
        this.b = dVCSRequestInformation.getService();
        this.a = dVCSRequestInformation.getVersion();
        this.d = dVCSRequestInformation.getNonce();
        this.e = dVCSRequestInformation.getRequestTime();
        this.g = dVCSRequestInformation.getRequestPolicy();
        this.h = dVCSRequestInformation.getDVCS();
        this.i = dVCSRequestInformation.getDataLocations();
    }

    public DVCSRequestInformation build() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != 1) {
            aSN1EncodableVector.add(new ASN1Integer(this.a));
        }
        aSN1EncodableVector.add(this.b);
        if (this.d != null) {
            aSN1EncodableVector.add(new ASN1Integer(this.d));
        }
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        int[] nArray = new int[]{0, 1, 2, 3, 4};
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{this.f, this.g, this.h, this.i, this.j};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            ASN1Encodable aSN1Encodable = aSN1EncodableArray[i2];
            if (aSN1Encodable == null) continue;
            aSN1EncodableVector.add(new DERTaggedObject(false, n2, aSN1Encodable));
        }
        return DVCSRequestInformation.getInstance(new DERSequence(aSN1EncodableVector));
    }

    public void setVersion(int n2) {
        if (this.c != null) {
            throw new IllegalStateException("cannot change version in existing DVCSRequestInformation");
        }
        this.a = n2;
    }

    public void setNonce(BigInteger bigInteger) {
        if (this.c != null) {
            if (this.c.getNonce() == null) {
                this.d = bigInteger;
            } else {
                byte[] byArray = this.c.getNonce().toByteArray();
                byte[] byArray2 = BigIntegers.asUnsignedByteArray(bigInteger);
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                this.d = new BigInteger(byArray3);
            }
        }
        this.d = bigInteger;
    }

    public void setRequestTime(DVCSTime dVCSTime) {
        if (this.c != null) {
            throw new IllegalStateException("cannot change request time in existing DVCSRequestInformation");
        }
        this.e = dVCSTime;
    }

    public void setRequester(GeneralName generalName) {
        this.setRequester(new GeneralNames(generalName));
    }

    public void setRequester(GeneralNames generalNames) {
        this.f = generalNames;
    }

    public void setRequestPolicy(PolicyInformation policyInformation) {
        if (this.c != null) {
            throw new IllegalStateException("cannot change request policy in existing DVCSRequestInformation");
        }
        this.g = policyInformation;
    }

    public void setDVCS(GeneralName generalName) {
        this.setDVCS(new GeneralNames(generalName));
    }

    public void setDVCS(GeneralNames generalNames) {
        this.h = generalNames;
    }

    public void setDataLocations(GeneralName generalName) {
        this.setDataLocations(new GeneralNames(generalName));
    }

    public void setDataLocations(GeneralNames generalNames) {
        this.i = generalNames;
    }

    public void setExtensions(Extensions extensions) {
        if (this.c != null) {
            throw new IllegalStateException("cannot change extensions in existing DVCSRequestInformation");
        }
        this.j = extensions;
    }
}

