/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.bc;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERGeneralizedTime;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERUTF8String;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.util.Date;

public class ObjectData
extends ASN1Object {
    private final BigInteger a;
    private final String b;
    private final ASN1GeneralizedTime c;
    private final ASN1GeneralizedTime d;
    private final ASN1OctetString e;
    private final String f;

    private ObjectData(ASN1Sequence aSN1Sequence) {
        this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue();
        this.b = DERUTF8String.getInstance(aSN1Sequence.getObjectAt(1)).getString();
        this.c = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(2));
        this.d = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(3));
        this.e = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(4));
        this.f = aSN1Sequence.size() == 6 ? DERUTF8String.getInstance(aSN1Sequence.getObjectAt(5)).getString() : null;
    }

    public ObjectData(BigInteger bigInteger, String string, Date date, Date date2, byte[] byArray, String string2) {
        this.a = bigInteger;
        this.b = string;
        this.c = new DERGeneralizedTime(date);
        this.d = new DERGeneralizedTime(date2);
        this.e = new DEROctetString(Arrays.clone(byArray));
        this.f = string2;
    }

    public static ObjectData getInstance(Object object) {
        if (object instanceof ObjectData) {
            return (ObjectData)object;
        }
        if (object != null) {
            return new ObjectData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public String getComment() {
        return this.f;
    }

    public ASN1GeneralizedTime getCreationDate() {
        return this.c;
    }

    public byte[] getData() {
        return Arrays.clone(this.e.getOctets());
    }

    public String getIdentifier() {
        return this.b;
    }

    public ASN1GeneralizedTime getLastModifiedDate() {
        return this.d;
    }

    public BigInteger getType() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new DERUTF8String(this.b));
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        if (this.f != null) {
            aSN1EncodableVector.add(new DERUTF8String(this.f));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

