/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.util.Enumeration;
import java.util.Properties;
import org.jfree.report.util.TextUtilities;

public class CharacterEntityParser {
    private final Properties entities;
    private final Properties reverse;

    public CharacterEntityParser(Properties properties) {
        this.entities = properties;
        this.reverse = new Properties();
        Enumeration<Object> enumeration = this.entities.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.entities.getProperty(string);
            this.reverse.setProperty(string2, string);
        }
    }

    public static CharacterEntityParser createXMLEntityParser() {
        Properties properties = new Properties();
        properties.setProperty("amp", "&");
        properties.setProperty("quot", "\"");
        properties.setProperty("lt", "<");
        properties.setProperty("gt", ">");
        properties.setProperty("apos", "'");
        return new CharacterEntityParser(properties);
    }

    private Properties getEntities() {
        return this.entities;
    }

    private Properties getReverse() {
        return this.reverse;
    }

    private String lookupCharacter(String string) {
        return this.getEntities().getProperty(string);
    }

    private String lookupEntity(String string) {
        String string2 = this.getReverse().getProperty(string);
        if (string2 == null) {
            return null;
        }
        return "&" + string2 + ";";
    }

    public String encodeEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            String string2 = String.valueOf(string.charAt(i));
            String string3 = this.lookupEntity(string2);
            if (string3 == null) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public String decodeEntities(String string) {
        int n = 0;
        int n2 = string.indexOf("&", n);
        if (n2 == -1) {
            return string;
        }
        int n3 = string.indexOf(";", n2);
        if (n3 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n2));
        do {
            Object object;
            if (string.charAt(n2 + 1) == '#') {
                int n4 = TextUtilities.parseInt(string.substring(n2 + 2, n3), 0);
                if (n4 >= 1 && n4 <= 65536) {
                    object = new char[1];
                    object[0] = (char)n4;
                    stringBuffer.append((char[])object);
                } else {
                    stringBuffer.append(string.substring(n2, n3));
                }
            } else {
                String string2 = string.substring(n2 + 1, n3);
                object = this.lookupCharacter(string2);
                if (object != null) {
                    stringBuffer.append(this.decodeEntities((String)object));
                } else {
                    stringBuffer.append("&");
                    stringBuffer.append(string2);
                    stringBuffer.append(";");
                }
            }
            n = n3 + 1;
            n2 = string.indexOf("&", n);
            if (n2 == -1) {
                stringBuffer.append(string.substring(n));
                n3 = -1;
                continue;
            }
            n3 = string.indexOf(";", n2);
            if (n3 == -1) {
                stringBuffer.append(string.substring(n));
                continue;
            }
            stringBuffer.append(string.substring(n, n2));
        } while (n2 != -1 && n3 != -1);
        return stringBuffer.toString();
    }
}

