/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.eac.jcajce;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.eac.ECDSAPublicKey;
import com.aspose.cad.internal.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.aspose.cad.internal.bouncycastle.asn1.eac.RSAPublicKey;
import com.aspose.cad.internal.bouncycastle.eac.EACException;
import com.aspose.cad.internal.bouncycastle.eac.jcajce.a;
import com.aspose.cad.internal.bouncycastle.eac.jcajce.b;
import com.aspose.cad.internal.bouncycastle.eac.jcajce.c;
import com.aspose.cad.internal.bouncycastle.eac.jcajce.d;
import com.aspose.cad.internal.bouncycastle.math.ec.ECAlgorithms;
import com.aspose.cad.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.cad.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.cad.internal.bouncycastle.math.field.FiniteField;
import com.aspose.cad.internal.bouncycastle.math.field.Polynomial;
import com.aspose.cad.internal.bouncycastle.math.field.PolynomialExtensionField;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;

public class JcaPublicKeyConverter {
    private b a = new a();

    public JcaPublicKeyConverter setProvider(String string) {
        this.a = new c(string);
        return this;
    }

    public JcaPublicKeyConverter setProvider(Provider provider) {
        this.a = new d(provider);
        return this;
    }

    public PublicKey getKey(PublicKeyDataObject publicKeyDataObject) throws EACException, InvalidKeySpecException {
        if (publicKeyDataObject.getUsage().on(EACObjectIdentifiers.id_TA_ECDSA)) {
            return this.a((ECDSAPublicKey)publicKeyDataObject);
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKeyDataObject;
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        try {
            KeyFactory keyFactory = this.a.a("RSA");
            return keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new EACException("cannot find provider: " + noSuchProviderException.getMessage(), noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EACException("cannot find algorithm ECDSA: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    private PublicKey a(ECDSAPublicKey eCDSAPublicKey) throws EACException, InvalidKeySpecException {
        KeyFactory keyFactory;
        ECParameterSpec eCParameterSpec = this.c(eCDSAPublicKey);
        java.security.spec.ECPoint eCPoint = this.b(eCDSAPublicKey);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        try {
            keyFactory = this.a.a("ECDSA");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new EACException("cannot find provider: " + noSuchProviderException.getMessage(), noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EACException("cannot find algorithm ECDSA: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        return keyFactory.generatePublic(eCPublicKeySpec);
    }

    private java.security.spec.ECPoint b(ECDSAPublicKey eCDSAPublicKey) {
        if (!eCDSAPublicKey.hasParameters()) {
            throw new IllegalArgumentException("Public key does not contains EC Params");
        }
        BigInteger bigInteger = eCDSAPublicKey.getPrimeModulusP();
        ECCurve.Fp fp2 = new ECCurve.Fp(bigInteger, eCDSAPublicKey.getFirstCoefA(), eCDSAPublicKey.getSecondCoefB(), eCDSAPublicKey.getOrderOfBasePointR(), eCDSAPublicKey.getCofactorF());
        ECPoint.Fp fp3 = (ECPoint.Fp)fp2.decodePoint(eCDSAPublicKey.getPublicPointY());
        return new java.security.spec.ECPoint(fp3.getAffineXCoord().toBigInteger(), fp3.getAffineYCoord().toBigInteger());
    }

    private ECParameterSpec c(ECDSAPublicKey eCDSAPublicKey) {
        if (!eCDSAPublicKey.hasParameters()) {
            throw new IllegalArgumentException("Public key does not contains EC Params");
        }
        BigInteger bigInteger = eCDSAPublicKey.getPrimeModulusP();
        ECCurve.Fp fp2 = new ECCurve.Fp(bigInteger, eCDSAPublicKey.getFirstCoefA(), eCDSAPublicKey.getSecondCoefB(), eCDSAPublicKey.getOrderOfBasePointR(), eCDSAPublicKey.getCofactorF());
        ECPoint eCPoint = fp2.decodePoint(eCDSAPublicKey.getBasePointG());
        BigInteger bigInteger2 = eCDSAPublicKey.getOrderOfBasePointR();
        BigInteger bigInteger3 = eCDSAPublicKey.getCofactorF();
        EllipticCurve ellipticCurve = JcaPublicKeyConverter.a(fp2);
        return new ECParameterSpec(ellipticCurve, new java.security.spec.ECPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()), bigInteger2, bigInteger3.intValue());
    }

    public PublicKeyDataObject getPublicKeyDataObject(ASN1ObjectIdentifier aSN1ObjectIdentifier, PublicKey publicKey) {
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)publicKey;
            return new RSAPublicKey(aSN1ObjectIdentifier, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }
        ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        return new ECDSAPublicKey(aSN1ObjectIdentifier, ((ECFieldFp)eCParameterSpec.getCurve().getField()).getP(), eCParameterSpec.getCurve().getA(), eCParameterSpec.getCurve().getB(), JcaPublicKeyConverter.a(JcaPublicKeyConverter.a(eCParameterSpec.getCurve(), eCParameterSpec.getOrder(), eCParameterSpec.getCofactor()), eCParameterSpec.getGenerator()).getEncoded(), eCParameterSpec.getOrder(), JcaPublicKeyConverter.a(JcaPublicKeyConverter.a(eCParameterSpec.getCurve(), eCParameterSpec.getOrder(), eCParameterSpec.getCofactor()), eCPublicKey.getW()).getEncoded(), eCParameterSpec.getCofactor());
    }

    private static ECPoint a(ECCurve eCCurve, java.security.spec.ECPoint eCPoint) {
        return eCCurve.createPoint(eCPoint.getAffineX(), eCPoint.getAffineY());
    }

    private static ECCurve a(EllipticCurve ellipticCurve, BigInteger bigInteger, int n2) {
        ECField eCField = ellipticCurve.getField();
        BigInteger bigInteger2 = ellipticCurve.getA();
        BigInteger bigInteger3 = ellipticCurve.getB();
        if (eCField instanceof ECFieldFp) {
            return new ECCurve.Fp(((ECFieldFp)eCField).getP(), bigInteger2, bigInteger3, bigInteger, BigInteger.valueOf(n2));
        }
        throw new IllegalStateException("not implemented yet!!!");
    }

    private static EllipticCurve a(ECCurve eCCurve) {
        ECField eCField = JcaPublicKeyConverter.a(eCCurve.getField());
        BigInteger bigInteger = eCCurve.getA().toBigInteger();
        BigInteger bigInteger2 = eCCurve.getB().toBigInteger();
        return new EllipticCurve(eCField, bigInteger, bigInteger2, null);
    }

    private static ECField a(FiniteField finiteField) {
        if (ECAlgorithms.isFpField(finiteField)) {
            return new ECFieldFp(finiteField.getCharacteristic());
        }
        Polynomial polynomial = ((PolynomialExtensionField)finiteField).getMinimalPolynomial();
        int[] nArray = polynomial.getExponentsPresent();
        int[] nArray2 = Arrays.reverse(Arrays.copyOfRange(nArray, 1, nArray.length - 1));
        return new ECFieldF2m(polynomial.getDegree(), nArray2);
    }
}

