/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style;

import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorFeature;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public class CSSValueResolverUtility {
    public static final double DEFAULT_X_HEIGHT_FACTOR = 0.58;
    private static CSSNumericType[] types = new CSSNumericType[]{CSSNumericType.CM, CSSNumericType.MM, CSSNumericType.PX, CSSNumericType.PT, CSSNumericType.PC, CSSNumericType.INCH};
    private static double[] vals = new double[]{254.0, 2540.0, 9600.0, 7200.0, 600.0, 100.0};

    public static boolean isAbsoluteValue(CSSNumericValue cSSNumericValue) {
        if (CSSNumericType.PT.equals(cSSNumericValue.getType())) {
            return true;
        }
        if (CSSNumericType.PC.equals(cSSNumericValue.getType())) {
            return true;
        }
        if (CSSNumericType.INCH.equals(cSSNumericValue.getType())) {
            return true;
        }
        if (CSSNumericType.CM.equals(cSSNumericValue.getType())) {
            return true;
        }
        if (CSSNumericType.MM.equals(cSSNumericValue.getType())) {
            return true;
        }
        return CSSNumericType.PX.equals(cSSNumericValue.getType());
    }

    public static boolean isLengthValue(CSSNumericValue cSSNumericValue) {
        if (CSSNumericType.PT.equals(cSSNumericValue.getType())) {
            return true;
        }
        if (CSSNumericType.PC.equals(cSSNumericValue.getType())) {
            return true;
        }
        if (CSSNumericType.INCH.equals(cSSNumericValue.getType())) {
            return true;
        }
        if (CSSNumericType.CM.equals(cSSNumericValue.getType())) {
            return true;
        }
        if (CSSNumericType.MM.equals(cSSNumericValue.getType())) {
            return true;
        }
        if (CSSNumericType.EM.equals(cSSNumericValue.getType())) {
            return true;
        }
        if (CSSNumericType.EX.equals(cSSNumericValue.getType())) {
            return true;
        }
        return CSSNumericType.PX.equals(cSSNumericValue.getType());
    }

    public static double convertLengthToDouble(CSSValue cSSValue) {
        return CSSValueResolverUtility.convertLengthToDouble(cSSValue, null, null);
    }

    public static strictfp double convertLengthToDouble(CSSValue cSSValue, LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        if (!(cSSValue instanceof CSSNumericValue)) {
            return 0.0;
        }
        CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
        if (CSSNumericType.PT.equals(cSSNumericValue.getType())) {
            return cSSNumericValue.getValue();
        }
        if (CSSNumericType.PC.equals(cSSNumericValue.getType())) {
            return cSSNumericValue.getValue() / 12.0;
        }
        if (CSSNumericType.INCH.equals(cSSNumericValue.getType())) {
            return cSSNumericValue.getValue() / 72.0;
        }
        if (CSSNumericType.CM.equals(cSSNumericValue.getType())) {
            return cSSNumericValue.getValue() * 100.0 * 72.0 / 254.0;
        }
        if (CSSNumericType.MM.equals(cSSNumericValue.getType())) {
            return cSSNumericValue.getValue() * 10.0 * 72.0 / 254.0;
        }
        if (CSSNumericType.PX.equals(cSSNumericValue.getType())) {
            int n = outputProcessorMetaData != null ? (int)outputProcessorMetaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION) : 96;
            if (n <= 0) {
                return cSSNumericValue.getValue();
            }
            return cSSNumericValue.getValue() * 72.0 / (double)n;
        }
        if (outputProcessorMetaData == null) {
            return 0.0;
        }
        if (layoutContext != null) {
            if (CSSNumericType.EM.equals(cSSNumericValue.getType())) {
                FontSpecification fontSpecification = layoutContext.getFontSpecification();
                double d = fontSpecification.getFontSize();
                return d * cSSNumericValue.getValue();
            }
            if (CSSNumericType.EX.equals(cSSNumericValue.getType())) {
                FontSpecification fontSpecification = layoutContext.getFontSpecification();
                FontMetrics fontMetrics = outputProcessorMetaData.getFontMetrics(fontSpecification);
                if (fontMetrics == null) {
                    long l = (long)(fontSpecification.getFontSize() * 0.58);
                    return StrictGeomUtility.toExternalValue((long)(cSSNumericValue.getValue() * (double)l));
                }
                return StrictGeomUtility.toExternalValue((long)(cSSNumericValue.getValue() * (double)fontMetrics.getXHeight()));
            }
        }
        return 0.0;
    }

    public static strictfp long convertLengthToLong(CSSValue cSSValue, LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        if (!(cSSValue instanceof CSSNumericValue)) {
            return 0L;
        }
        CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
        long l = StrictGeomUtility.toInternalValue(cSSNumericValue.getValue());
        if (CSSNumericType.PT.equals(cSSNumericValue.getType())) {
            return l;
        }
        if (CSSNumericType.PC.equals(cSSNumericValue.getType())) {
            return l / 12L;
        }
        if (CSSNumericType.INCH.equals(cSSNumericValue.getType())) {
            return l / 72L;
        }
        if (CSSNumericType.CM.equals(cSSNumericValue.getType())) {
            return l * 100L * 72L / 254L;
        }
        if (CSSNumericType.MM.equals(cSSNumericValue.getType())) {
            return l * 10L * 72L / 254L;
        }
        if (CSSNumericType.PX.equals(cSSNumericValue.getType())) {
            int n = outputProcessorMetaData != null ? (int)outputProcessorMetaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION) : 96;
            if (n <= 0) {
                return l;
            }
            return l * 72L / (long)n;
        }
        if (outputProcessorMetaData == null) {
            return 0L;
        }
        if (layoutContext != null) {
            if (CSSNumericType.EM.equals(cSSNumericValue.getType())) {
                FontSpecification fontSpecification = layoutContext.getFontSpecification();
                double d = fontSpecification.getFontSize();
                return (long)(d * (double)l);
            }
            if (CSSNumericType.EX.equals(cSSNumericValue.getType())) {
                FontSpecification fontSpecification = layoutContext.getFontSpecification();
                FontMetrics fontMetrics = outputProcessorMetaData.getFontMetrics(fontSpecification);
                if (fontMetrics == null) {
                    long l2 = (long)(fontSpecification.getFontSize() * 0.58);
                    return StrictGeomUtility.multiply(l, l2);
                }
                return StrictGeomUtility.multiply(l, fontMetrics.getXHeight());
            }
        }
        return 0L;
    }

    public static CSSNumericValue convertLength(CSSValue cSSValue, LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        return CSSNumericValue.createValue(CSSNumericType.PT, CSSValueResolverUtility.convertLengthToDouble(cSSValue, layoutContext, outputProcessorMetaData));
    }

    public static CSSNumericValue getLength(CSSValue cSSValue) {
        if (!(cSSValue instanceof CSSNumericValue)) {
            return null;
        }
        CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
        if (CSSValueResolverUtility.isNumericType(CSSNumericType.PERCENTAGE, cSSNumericValue)) {
            return null;
        }
        return cSSNumericValue;
    }

    private static boolean isNumericType(CSSNumericType cSSNumericType, CSSValue cSSValue) {
        if (!(cSSValue instanceof CSSNumericValue)) {
            return false;
        }
        CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
        return cSSNumericValue.getType().equals(cSSNumericType);
    }

    public static CSSNumericValue getLength(CSSValue cSSValue, CSSNumericValue cSSNumericValue) {
        if (!(cSSValue instanceof CSSNumericValue)) {
            return null;
        }
        CSSNumericValue cSSNumericValue2 = (CSSNumericValue)cSSValue;
        if (CSSValueResolverUtility.isNumericType(CSSNumericType.PERCENTAGE, cSSNumericValue2)) {
            if (cSSNumericValue == null) {
                return null;
            }
            double d = cSSNumericValue2.getValue();
            return CSSNumericValue.createValue(cSSNumericValue.getType(), cSSNumericValue.getValue() * d / 100.0);
        }
        return cSSNumericValue2;
    }

    public static boolean isURI(CSSValue cSSValue) {
        if (!(cSSValue instanceof CSSStringValue)) {
            return false;
        }
        CSSStringValue cSSStringValue = (CSSStringValue)cSSValue;
        return cSSStringValue.getType().equals(CSSStringType.URI);
    }

    public static double getNumericValue(CSSValue cSSValue, double d) {
        CSSNumericValue cSSNumericValue;
        if (cSSValue instanceof CSSNumericValue && CSSNumericType.NUMBER.equals((cSSNumericValue = (CSSNumericValue)cSSValue).getType())) {
            return cSSNumericValue.getValue();
        }
        return d;
    }

    public static CSSNumericValue convertLength(CSSNumericValue cSSNumericValue, CSSNumericType cSSNumericType) {
        if (cSSNumericType == CSSNumericType.NUMBER || cSSNumericType == CSSNumericType.PERCENTAGE || cSSNumericType == CSSNumericType.DEG) {
            throw new IllegalArgumentException();
        }
        CSSNumericType cSSNumericType2 = cSSNumericValue.getType();
        if (cSSNumericType2 == CSSNumericType.NUMBER || cSSNumericType2 == CSSNumericType.PERCENTAGE || cSSNumericType2 == CSSNumericType.DEG) {
            throw new IllegalArgumentException();
        }
        if (cSSNumericType2 == cSSNumericType) {
            return cSSNumericValue;
        }
        double d = CSSValueResolverUtility.getFactor(cSSNumericType);
        double d2 = CSSValueResolverUtility.getFactor(cSSNumericType2);
        double d3 = cSSNumericValue.getValue() * d / d2;
        return CSSNumericValue.createValue(cSSNumericType, d3);
    }

    private static double getFactor(CSSNumericType cSSNumericType) {
        for (int i = 0; i < types.length; ++i) {
            CSSNumericType cSSNumericType2 = types[i];
            if (cSSNumericType != cSSNumericType2) continue;
            return vals[i];
        }
        throw new IllegalArgumentException();
    }

    private CSSValueResolverUtility() {
    }
}

