/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.TwipsConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RowStyle
extends Style
implements Cloneable {
    private int rowHeight = 255;

    public RowStyle(Node node, StyleCatalog sc) {
        super(node, sc);
        NamedNodeMap attrNodes = node.getAttributes();
        if (attrNodes != null) {
            int len = attrNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node attr = attrNodes.item(i);
                this.handleAttribute(attr.getNodeName(), attr.getNodeValue());
            }
        }
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList children = node.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            NamedNodeMap childAttrNodes;
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (!nodeName.equals("style:properties") || (childAttrNodes = child.getAttributes()) == null) continue;
            int nChildAttrNodes = childAttrNodes.getLength();
            for (int j = 0; j < nChildAttrNodes; ++j) {
                Node attr = childAttrNodes.item(j);
                this.handleAttribute(attr.getNodeName(), attr.getNodeValue());
            }
        }
    }

    public RowStyle(String name, String family, String parent, int rowHeight, StyleCatalog sc) {
        super(name, family, parent, sc);
        this.rowHeight = rowHeight;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    private void setRowHeight(int RowHeight) {
        this.rowHeight = RowHeight;
    }

    private int parseRowHeight(String value) {
        return TwipsConverter.convert2twips(value, 255);
    }

    private void handleAttribute(String attr, String value) {
        if (attr.equals("style:row-height")) {
            this.rowHeight = this.parseRowHeight(value);
        } else {
            Debug.log(1, "RowStyle Unhandled: " + attr + "=" + value);
        }
    }

    @Override
    public Style getResolved() {
        RowStyle resolved = null;
        try {
            resolved = (RowStyle)this.clone();
        }
        catch (Exception e) {
            Debug.log(2, "Can't clone", e);
        }
        RowStyle parentStyle = null;
        if (this.sc != null) {
            if (this.parent != null) {
                parentStyle = (RowStyle)this.sc.lookup(this.parent, this.family, null, this.getClass());
                if (parentStyle == null) {
                    Debug.log(2, "parent style lookup of " + this.parent + " failed!");
                } else {
                    parentStyle = (RowStyle)parentStyle.getResolved();
                }
            } else if (!this.name.equals("DEFAULT_STYLE")) {
                parentStyle = (RowStyle)this.sc.lookup("DEFAULT_STYLE", null, null, this.getClass());
            }
        }
        if (parentStyle != null) {
            parentStyle = (RowStyle)parentStyle.getResolved();
            if (this.rowHeight == 0 && parentStyle.getRowHeight() != 0) {
                resolved.setRowHeight(parentStyle.getRowHeight());
            }
        }
        return resolved;
    }

    @Override
    public Node createNode(Document parentDoc, String name) {
        Element node = parentDoc.createElement(name);
        this.writeAttributes(node);
        return node;
    }

    @Override
    public boolean isSubset(Style style) {
        if (style.getClass() != this.getClass()) {
            return false;
        }
        RowStyle tStyle = (RowStyle)style;
        return this.rowHeight == tStyle.getRowHeight();
    }

    private void writeAttributes(Element node) {
        if (this.rowHeight != 0) {
            String height = TwipsConverter.twips2cm(this.rowHeight) + "cm";
            node.setAttribute("style:row-height", height);
        }
    }
}

