/*
 * Decompiled with CFR 0.152.
 */
package cpdetector.test;

import cpdetector.io.ASCIIDetector;
import cpdetector.io.CodepageDetectorProxy;
import cpdetector.io.FileFilterExtensions;
import cpdetector.io.ICodepageDetector;
import cpdetector.io.JChardetFacade;
import cpdetector.io.ParsingDetector;
import cpdetector.io.UnknownCharset;
import cpdetector.io.UnsupportedCharset;
import cpdetector.reflect.SingletonLoader;
import cpdetector.test.EncodingRepository;
import cpdetector.test.IStopWatch;
import cpdetector.test.StopWatchSimple;
import cpdetector.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class JunitLargeCollectionTest
extends TestCase {
    protected File collectionRoot = null;
    private String collectionRootName;
    protected CodepageDetectorProxy detector;
    private Charset[] parseCodepages;
    private static String fileseparator = System.getProperty("file.separator");
    private FileFilter extensionFilter;
    private int iterations = 1;
    private int filecount = 0;
    private List unDetected = new LinkedList();
    private List unEqual = new LinkedList();
    IStopWatch stopWatch = new StopWatchSimple(false);

    public JunitLargeCollectionTest(String methodName) throws Exception {
        super(methodName);
        this.detector = CodepageDetectorProxy.getInstance();
        this.parseArgs();
    }

    public void parseArgs() throws Exception {
        Properties sysProps = System.getProperties();
        Object collectionOption = sysProps.get("collectionRoot");
        Object extensionsOption = sysProps.get("extensions");
        Object iterationsOption = sysProps.get("iterations");
        Object detectorOption = sysProps.get("detectorList");
        if (collectionOption == null) {
            this.usage();
            throw new MissingResourceException("Parameter for collection root directory is missing.", "String", "-r");
        }
        this.collectionRoot = new File(collectionOption.toString());
        this.collectionRootName = this.collectionRoot.getAbsolutePath();
        this.extensionFilter = extensionsOption != null ? new FileFilterExtensions(this.parseCSVList(extensionsOption.toString())) : new FileFilter(){

            public boolean accept(File f) {
                return true;
            }
        };
        if (detectorOption != null) {
            String[] detectors = this.parseCSVList((String)detectorOption);
            if (detectors.length == 0) {
                StringBuffer msg = new StringBuffer();
                msg.append("You specified the codepage detector argument \"-c\" but ommited any comma-separated fully qualified class-name.");
                throw new IllegalArgumentException(msg.toString());
            }
            ICodepageDetector cpDetector = null;
            for (int i = 0; i < detectors.length; ++i) {
                try {
                    cpDetector = (ICodepageDetector)SingletonLoader.getInstance().newInstance(detectors[i]);
                    if (cpDetector == null) continue;
                    this.detector.add(cpDetector);
                    continue;
                }
                catch (InstantiationException ie) {
                    System.err.println("Could not instantiate custom ICodepageDetector: " + detectors[i] + " (argument \"-c\"): " + ie.getMessage());
                }
            }
        } else {
            this.detector.add(new ParsingDetector(false));
            this.detector.add(JChardetFacade.getInstance());
            this.detector.add(ASCIIDetector.getInstance());
        }
        if (iterationsOption != null) {
            this.iterations = Integer.parseInt(iterationsOption.toString());
        }
        this.loadCodepages();
    }

    private final String[] parseCSVList(String listLiteral) {
        if (listLiteral == null) {
            return null;
        }
        LinkedList<String> tmpList = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(listLiteral, ";,");
        while (tok.hasMoreElements()) {
            tmpList.add(tok.nextToken());
        }
        return tmpList.toArray(new String[tmpList.size()]);
    }

    private void processRecursive(File f) throws Exception {
        if (f == null) {
            throw new IllegalArgumentException("File argument is null!");
        }
        if (!f.exists()) {
            throw new IllegalArgumentException(f.getAbsolutePath() + " does not exist.");
        }
        if (f.isDirectory()) {
            File[] childs = f.listFiles();
            for (int i = childs.length - 1; i >= 0; --i) {
                this.processRecursive(childs[i]);
            }
        } else if (this.extensionFilter.accept(f)) {
            this.process(f);
        }
    }

    public final void process() throws Exception {
        this.processRecursive(this.collectionRoot);
    }

    public void report() {
        System.out.println("Processed " + this.filecount + " * " + this.iterations + " = " + this.filecount * this.iterations + " in " + this.stopWatch.getPureMilliSeconds() + " ms.");
        if (this.unDetected.size() > 0) {
            System.out.println(this.unDetected.size() + " undetected documents:");
            Iterator unDetectedIt = this.unDetected.iterator();
            while (unDetectedIt.hasNext()) {
                System.out.println(unDetectedIt.next().toString());
            }
        } else {
            System.out.println("No undetected codepages.");
        }
        if (this.unEqual.size() > 0) {
            System.out.println(this.unEqual.size() + " documents differ between detected an human verified:");
            Iterator unEqualIt = this.unEqual.iterator();
            while (unEqualIt.hasNext()) {
                System.out.println(unEqualIt.next().toString());
            }
        } else {
            System.out.println("All documents were detected as human-verified.");
        }
    }

    protected void verifyFiles() throws IllegalArgumentException {
        StringBuffer msg = new StringBuffer();
        if (this.collectionRoot == null) {
            msg.append("-> Collection root directory is null!\n");
        } else if (!this.collectionRoot.exists()) {
            msg.append("-> Collection root directory:\"");
            msg.append(this.collectionRoot.getAbsolutePath());
            msg.append("\" does not exist!\n");
        }
        if (msg.length() > 0) {
            throw new IllegalArgumentException(msg.toString());
        }
        System.out.println("All parameters are valid.");
    }

    private void process(File document) throws Exception {
        Charset detected = null;
        Charset verified = null;
        String filename = document.getAbsolutePath();
        int length = (int)document.length();
        if (!this.collectionRoot.equals(document)) {
            filename = filename.substring(this.collectionRootName.length());
        }
        System.out.println("Processing: " + filename);
        InputStream cache = FileUtil.readCache(document);
        this.stopWatch.start();
        for (int i = this.iterations; i > 0; --i) {
            cache.reset();
            detected = this.detector.detectCodepage(cache, length);
        }
        this.stopWatch.stop();
        System.out.println("Detected: " + String.valueOf(detected) + " class: " + detected.getClass().getName() + " instance: " + detected.getClass().getName() + "@" + Integer.toHexString(detected.hashCode()));
        try {
            verified = EncodingRepository.getInstance().getVerifiedEncoding(document.toURL());
        }
        catch (IOException ioex) {
            JunitLargeCollectionTest.fail((String)ioex.toString());
        }
        System.out.println("Human verified: " + String.valueOf(verified) + " class: " + verified.getClass() + " instance: " + verified.getClass().getName() + "@" + Integer.toHexString(verified.hashCode()));
        if (detected == UnknownCharset.getInstance()) {
            this.unDetected.add(filename);
        }
        if (verified != detected) {
            if (!FileUtil.isAllASCII(document)) {
                if (detected != UnknownCharset.getInstance() && detected.getClass() != UnsupportedCharset.class) {
                    if (!FileUtil.isEqual(document, detected, verified)) {
                        JunitLargeCollectionTest.assertSame((Object)detected, (Object)verified);
                    }
                } else {
                    JunitLargeCollectionTest.assertSame((Object)detected, (Object)verified);
                }
            }
            this.unEqual.add(filename);
        }
        ++this.filecount;
    }

    protected void describe() {
        StringBuffer msg = new StringBuffer();
        msg.append("Setup:\n");
        msg.append("  Collection-Root         : ");
        msg.append(this.collectionRoot.getAbsolutePath());
        msg.append("\n");
        msg.append("  iterations per document : ");
        msg.append(this.iterations);
        msg.append("n");
        msg.append("  detection algorithm     : ");
        msg.append("\n");
        msg.append(this.detector.toString());
        System.out.println(msg.toString());
    }

    protected void usage() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("This test reads system properties!");
        tmp.append("\n");
        tmp.append("Properties: \n");
        tmp.append("\n  Optional:\n");
        tmp.append("  -extensions     : A comma- or semicolon- separated string for document extensions like \"-e txt,dat\" (without dot or space!).\n");
        tmp.append("  -iterations     : Iterations per document. A high value decreases time measurement error \n");
        tmp.append("                     but causes the test to take longer.\n");
        tmp.append("  -detectorList   : Semicolon-separated list of fully qualified classnames. \n");
        tmp.append("                    These classes will be casted to ICodepageDetector instances \n");
        tmp.append("                    and used in the order specified.\n");
        tmp.append("                    If this argument is ommited, a HTMLCodepageDetector followed by .\n");
        tmp.append("                    a JChardetFacade is used by default.\n");
        tmp.append("  Mandatory:\n");
        tmp.append("  -collectionRoot  : Root directory containing the collection (recursive).\n");
        System.out.print(tmp.toString());
    }

    void loadCodepages() {
        System.out.println("Loading available codepages...");
        SortedMap<String, Charset> charSets = Charset.availableCharsets();
        Iterator<Map.Entry<String, Charset>> csIt = charSets.entrySet().iterator();
        this.parseCodepages = new Charset[charSets.size()];
        int index = 0;
        while (csIt.hasNext()) {
            Map.Entry<String, Charset> entry = csIt.next();
            Charset cs = entry.getValue();
            System.out.println("  " + cs.name());
            System.out.println("   aliases: ");
            Iterator<String> aliases = cs.aliases().iterator();
            while (aliases.hasNext()) {
                System.out.println("      " + aliases.next().toString());
            }
            this.parseCodepages[index] = cs;
            ++index;
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        try {
            final JunitLargeCollectionTest testbase = new JunitLargeCollectionTest("process");
            testbase.verifyFiles();
            testbase.describe();
            LinkedList testlist = new LinkedList();
            JunitLargeCollectionTest.fillTestCases(testbase, testlist, testbase.collectionRoot);
            Iterator testIt = testlist.iterator();
            while (testIt.hasNext()) {
                final File currentF = (File)testIt.next();
                System.out.println("Adding Testcase for file: " + currentF.getAbsolutePath());
                suite.addTest((Test)new TestCase("Document " + currentF.getAbsolutePath()){
                    final File f;
                    {
                        super(x0);
                        this.f = currentF;
                    }

                    public void runTest() throws Exception {
                        testbase.process(this.f);
                    }
                });
            }
        }
        catch (Exception e) {
            JunitLargeCollectionTest.fail((String)e.getMessage());
            System.err.println(e.getMessage());
        }
        System.out.println(suite.countTestCases() + " different Testscases.");
        return suite;
    }

    private static void fillTestCases(JunitLargeCollectionTest testbase, List testlist, File f) {
        if (f == null) {
            throw new IllegalArgumentException("File argument is null!");
        }
        if (!f.exists()) {
            throw new IllegalArgumentException(f.getAbsolutePath() + " does not exist.");
        }
        if (f.isDirectory()) {
            File[] childs = f.listFiles();
            for (int i = childs.length - 1; i >= 0; --i) {
                JunitLargeCollectionTest.fillTestCases(testbase, testlist, childs[i]);
            }
        } else if (testbase.extensionFilter.accept(f)) {
            testlist.add(f);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            JunitLargeCollectionTest detector = new JunitLargeCollectionTest("process");
            detector.process();
        }
        catch (Exception e) {
            JunitLargeCollectionTest.fail((String)e.getMessage());
            System.err.println(e.getMessage());
        }
    }
}

