/*
 * Decompiled with CFR 0.152.
 */
package cpdetector.io;

import antlr.ANTLRException;
import cpdetector.io.AbstractCodepageDetector;
import cpdetector.io.UnknownCharset;
import cpdetector.io.UnsupportedCharset;
import cpdetector.io.parser.EncodingLexer;
import cpdetector.io.parser.EncodingParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;

public class ParsingDetector
extends AbstractCodepageDetector {
    private boolean verbose = false;

    public ParsingDetector() {
        this(false);
    }

    public ParsingDetector(boolean verbose) {
        this.verbose = verbose;
    }

    public Charset detectCodepage(URL url) throws IOException {
        return this.detectCodepage(new BufferedInputStream(url.openStream()), Integer.MAX_VALUE);
    }

    public Charset detectCodepage(InputStream in, int length) throws IOException {
        Charset charset;
        block6: {
            charset = null;
            String csName = null;
            if (this.verbose) {
                System.out.println("  parsing for html-charset/xml-encoding attribute with codepage: US-ASCII");
            }
            try {
                EncodingLexer lexer = new EncodingLexer(new InputStreamReader(in, "US-ASCII"));
                EncodingParser parser = new EncodingParser(lexer);
                csName = parser.htmlDocument();
                charset = csName != null ? Charset.forName(csName) : UnknownCharset.getInstance();
            }
            catch (ANTLRException ae) {
                if (this.verbose) {
                    System.out.println("  ANTLR parser exception: " + ae.getMessage());
                }
            }
            catch (Exception deepdown) {
                if (this.verbose) {
                    System.out.println("  Decoding Exception: " + deepdown.getMessage() + " (unsupported java charset).");
                }
                if (charset != null) break block6;
                charset = csName != null ? UnsupportedCharset.forName(csName) : UnknownCharset.getInstance();
            }
        }
        return charset;
    }
}

