/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.beans;

import java.util.Locale;
import java.util.StringTokenizer;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.ValueConverter;

public class LocaleValueConverter
implements ValueConverter {
    @Override
    public String toAttributeValue(Object object) throws BeanException {
        Locale locale = (Locale)object;
        if (locale.getCountry().equals("")) {
            return locale.getLanguage();
        }
        if (locale.getVariant().equals("")) {
            return locale.getLanguage() + "_" + locale.getCountry();
        }
        return locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
    }

    @Override
    public Object toPropertyValue(String string) throws BeanException {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "_");
        if (!stringTokenizer.hasMoreElements()) {
            throw new BeanException("This is no valid locale specification.");
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        String string4 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        return new Locale(string2, string3, string4);
    }
}

