/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class NativeArray
extends IdScriptable {
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 2;
    private static final int Id_toString = 3;
    private static final int Id_toLocaleString = 4;
    private static final int Id_toSource = 5;
    private static final int Id_join = 6;
    private static final int Id_reverse = 7;
    private static final int Id_sort = 8;
    private static final int Id_push = 9;
    private static final int Id_pop = 10;
    private static final int Id_shift = 11;
    private static final int Id_unshift = 12;
    private static final int Id_splice = 13;
    private static final int Id_concat = 14;
    private static final int Id_slice = 15;
    private static final int MAX_PROTOTYPE_ID = 15;
    private long length;
    private Object[] dense;
    private static final int maximumDenseLength = 10000;
    private boolean prototypeFlag;
    private static final boolean check = true;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeArray obj = new NativeArray();
        obj.prototypeFlag = true;
        obj.addAsPrototype(15, cx, scope, sealed);
    }

    private NativeArray() {
        this.setMaxId(1);
        this.dense = null;
        this.length = 0L;
    }

    public NativeArray(long length) {
        this.setMaxId(1);
        int intLength = (int)length;
        if ((long)intLength == length && intLength > 0) {
            if (intLength > 10000) {
                intLength = 10000;
            }
            this.dense = new Object[intLength];
            for (int i = 0; i < intLength; ++i) {
                this.dense[i] = NOT_FOUND;
            }
        }
        this.length = length;
    }

    public NativeArray(Object[] array) {
        this.setMaxId(1);
        this.dense = array;
        this.length = array.length;
    }

    @Override
    public String getClassName() {
        return "Array";
    }

    @Override
    protected int getIdAttributes(int id) {
        if (id == 1) {
            return 6;
        }
        return super.getIdAttributes(id);
    }

    @Override
    protected Object getIdValue(int id) {
        if (id == 1) {
            return this.wrap_double(this.length);
        }
        return super.getIdValue(id);
    }

    @Override
    protected void setIdValue(int id, Object value) {
        if (id == 1) {
            this.setLength(value);
            return;
        }
        super.setIdValue(id, value);
    }

    @Override
    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 0;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 1;
                }
                case 11: {
                    return 1;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return 1;
                }
                case 14: {
                    return 1;
                }
                case 15: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    @Override
    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 2: {
                    return NativeArray.jsConstructor(cx, scope, args, f, thisObj == null);
                }
                case 3: {
                    return NativeArray.toStringHelper(cx, scope, thisObj, cx.hasFeature(4), false);
                }
                case 4: {
                    return NativeArray.toStringHelper(cx, scope, thisObj, false, true);
                }
                case 5: {
                    return NativeArray.toStringHelper(cx, scope, thisObj, true, false);
                }
                case 6: {
                    return NativeArray.js_join(cx, thisObj, args);
                }
                case 7: {
                    return NativeArray.js_reverse(cx, thisObj, args);
                }
                case 8: {
                    return NativeArray.js_sort(cx, scope, thisObj, args);
                }
                case 9: {
                    return NativeArray.js_push(cx, thisObj, args);
                }
                case 10: {
                    return NativeArray.js_pop(cx, thisObj, args);
                }
                case 11: {
                    return NativeArray.js_shift(cx, thisObj, args);
                }
                case 12: {
                    return NativeArray.js_unshift(cx, thisObj, args);
                }
                case 13: {
                    return NativeArray.js_splice(cx, scope, thisObj, args);
                }
                case 14: {
                    return NativeArray.js_concat(cx, scope, thisObj, args);
                }
                case 15: {
                    return this.js_slice(cx, thisObj, args);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.dense != null && 0 <= index && index < this.dense.length) {
            return this.dense[index];
        }
        return super.get(index, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (this.dense != null && 0 <= index && index < this.dense.length) {
            return this.dense[index] != NOT_FOUND;
        }
        return super.has(index, start);
    }

    private static long toArrayIndex(String id) {
        long index;
        double d = ScriptRuntime.toNumber(id);
        if (d == d && (double)(index = ScriptRuntime.toUint32(d)) == d && index != 0xFFFFFFFFL && Long.toString(index).equals(id)) {
            return index;
        }
        return -1L;
    }

    @Override
    public void put(String id, Scriptable start, Object value) {
        long index;
        super.put(id, start, value);
        if (start == this && (index = NativeArray.toArrayIndex(id)) >= this.length) {
            this.length = index + 1L;
        }
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (start == this && !this.isSealed() && this.dense != null && 0 <= index && index < this.dense.length) {
            this.dense[index] = value;
        } else {
            super.put(index, start, value);
        }
        if (start == this && this.length <= (long)index) {
            this.length = (long)index + 1L;
        }
    }

    @Override
    public void delete(int index) {
        if (!this.isSealed() && this.dense != null && 0 <= index && index < this.dense.length) {
            this.dense[index] = NOT_FOUND;
        } else {
            super.delete(index);
        }
    }

    @Override
    public Object[] getIds() {
        Object[] superIds = super.getIds();
        if (this.dense == null) {
            return superIds;
        }
        int N = this.dense.length;
        long currentLength = this.length;
        if ((long)N > currentLength) {
            N = (int)currentLength;
        }
        if (N == 0) {
            return superIds;
        }
        int superLength = superIds.length;
        Object[] ids = new Object[N + superLength];
        System.arraycopy(this.dense, 0, ids, 0, N);
        int presentCount = 0;
        for (int i = 0; i != N; ++i) {
            if (ids[i] == NOT_FOUND) continue;
            ids[presentCount] = new Integer(i);
            ++presentCount;
        }
        if (presentCount != N) {
            Object[] tmp = new Object[presentCount + superLength];
            System.arraycopy(ids, 0, tmp, 0, presentCount);
            ids = tmp;
        }
        System.arraycopy(superIds, 0, ids, presentCount, superLength);
        return ids;
    }

    @Override
    public Object getDefaultValue(Class hint) {
        Context cx;
        if (hint == ScriptRuntime.NumberClass && (cx = Context.getContext()).getLanguageVersion() == 120) {
            return new Long(this.length);
        }
        return super.getDefaultValue(hint);
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Object[] args, IdFunction ctorObj, boolean inNewExpr) throws JavaScriptException {
        if (!inNewExpr) {
            return ctorObj.construct(cx, scope, args);
        }
        if (args.length == 0) {
            return new NativeArray();
        }
        if (cx.getLanguageVersion() == 120) {
            return new NativeArray(args);
        }
        Object arg0 = args[0];
        if (args.length > 1 || !(arg0 instanceof Number)) {
            return new NativeArray(args);
        }
        long len = ScriptRuntime.toUint32(arg0);
        if ((double)len != ((Number)arg0).doubleValue()) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        return new NativeArray(len);
    }

    public long getLength() {
        return this.length;
    }

    public long jsGet_length() {
        return this.getLength();
    }

    private void setLength(Object val) {
        double d = ScriptRuntime.toNumber(val);
        long longVal = ScriptRuntime.toUint32(d);
        if ((double)longVal != d) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        if (longVal < this.length) {
            if (this.length - longVal > 4096L) {
                Object[] e = this.getIds();
                for (int i = 0; i < e.length; ++i) {
                    Object id = e[i];
                    if (id instanceof String) {
                        String strId = (String)id;
                        long index = NativeArray.toArrayIndex(strId);
                        if (index < longVal) continue;
                        this.delete(strId);
                        continue;
                    }
                    int index = (Integer)id;
                    if ((long)index < longVal) continue;
                    this.delete(index);
                }
            } else {
                for (long i = longVal; i < this.length; ++i) {
                    NativeArray.deleteElem(this, i);
                }
            }
        }
        this.length = longVal;
    }

    static long getLengthProperty(Scriptable obj) {
        if (obj instanceof NativeString) {
            return ((NativeString)obj).getLength();
        }
        if (obj instanceof NativeArray) {
            return ((NativeArray)obj).getLength();
        }
        if (!(obj instanceof Scriptable)) {
            return 0L;
        }
        return ScriptRuntime.toUint32(ScriptRuntime.getProp(obj, "length", obj));
    }

    private static void deleteElem(Scriptable target, long index) {
        int i = (int)index;
        if ((long)i == index) {
            target.delete(i);
        } else {
            target.delete(Long.toString(index));
        }
    }

    private static Object getElem(Scriptable target, long index) {
        if (index > Integer.MAX_VALUE) {
            String id = Long.toString(index);
            return ScriptRuntime.getStrIdElem(target, id);
        }
        return ScriptRuntime.getElem(target, (int)index);
    }

    private static void setElem(Scriptable target, long index, Object value) {
        if (index > Integer.MAX_VALUE) {
            String id = Long.toString(index);
            ScriptRuntime.setStrIdElem(target, id, value, target);
        } else {
            ScriptRuntime.setElem(target, (int)index, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toStringHelper(Context cx, Scriptable scope, Scriptable thisObj, boolean toSource, boolean toLocale) throws JavaScriptException {
        boolean iterating;
        boolean toplevel;
        String separator;
        long length = NativeArray.getLengthProperty(thisObj);
        StringBuffer result = new StringBuffer(256);
        if (toSource) {
            result.append('[');
            separator = ", ";
        } else {
            separator = ",";
        }
        boolean haslast = false;
        long i = 0L;
        if (cx.iterating == null) {
            toplevel = true;
            iterating = false;
            cx.iterating = new ObjToIntMap(31);
        } else {
            toplevel = false;
            iterating = cx.iterating.has(thisObj);
        }
        try {
            if (!iterating) {
                cx.iterating.put(thisObj, 0);
                for (i = 0L; i < length; ++i) {
                    Object elem;
                    if (i > 0L) {
                        result.append(separator);
                    }
                    if ((elem = NativeArray.getElem(thisObj, i)) == null || elem == Undefined.instance) {
                        haslast = false;
                        continue;
                    }
                    haslast = true;
                    if (toSource) {
                        result.append(ScriptRuntime.uneval(cx, scope, elem));
                        continue;
                    }
                    if (elem instanceof String) {
                        String s = (String)elem;
                        if (toSource) {
                            result.append('\"');
                            result.append(ScriptRuntime.escapeString(s));
                            result.append('\"');
                            continue;
                        }
                        result.append(s);
                        continue;
                    }
                    if (toLocale && elem != Undefined.instance && elem != null) {
                        Scriptable obj = ScriptRuntime.toObject(cx, thisObj, elem);
                        Object tls = ScriptRuntime.getProp(obj, "toLocaleString", thisObj);
                        elem = ScriptRuntime.call(cx, tls, elem, ScriptRuntime.emptyArgs);
                    }
                    result.append(ScriptRuntime.toString(elem));
                }
            }
        }
        finally {
            if (toplevel) {
                cx.iterating = null;
            }
        }
        if (toSource) {
            if (!haslast && i > 0L) {
                result.append(", ]");
            } else {
                result.append(']');
            }
        }
        return result.toString();
    }

    private static String js_join(Context cx, Scriptable thisObj, Object[] args) {
        String str;
        int length;
        long llength = NativeArray.getLengthProperty(thisObj);
        if (llength != (long)(length = (int)llength)) {
            throw Context.reportRuntimeError1("msg.arraylength.too.big", String.valueOf(llength));
        }
        String separator = args.length < 1 || args[0] == Undefined.instance ? "," : ScriptRuntime.toString(args[0]);
        if (length == 0) {
            return "";
        }
        String[] buf = new String[length];
        int total_size = 0;
        for (int i = 0; i != length; ++i) {
            Object temp = NativeArray.getElem(thisObj, i);
            if (temp == null || temp == Undefined.instance) continue;
            str = ScriptRuntime.toString(temp);
            total_size += str.length();
            buf[i] = str;
        }
        StringBuffer sb = new StringBuffer(total_size += (length - 1) * separator.length());
        for (int i = 0; i != length; ++i) {
            if (i != 0) {
                sb.append(separator);
            }
            if ((str = buf[i]) == null) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    private static Scriptable js_reverse(Context cx, Scriptable thisObj, Object[] args) {
        long len = NativeArray.getLengthProperty(thisObj);
        long half = len / 2L;
        for (long i = 0L; i < half; ++i) {
            long j = len - i - 1L;
            Object temp1 = NativeArray.getElem(thisObj, i);
            Object temp2 = NativeArray.getElem(thisObj, j);
            NativeArray.setElem(thisObj, i, temp2);
            NativeArray.setElem(thisObj, j, temp1);
        }
        return thisObj;
    }

    private static Scriptable js_sort(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        Object[] cmpBuf;
        Object compare;
        long length = NativeArray.getLengthProperty(thisObj);
        if (length <= 1L) {
            return thisObj;
        }
        if (args.length > 0 && Undefined.instance != args[0]) {
            compare = args[0];
            cmpBuf = new Object[2];
        } else {
            compare = null;
            cmpBuf = null;
        }
        if (length >= Integer.MAX_VALUE) {
            NativeArray.heapsort_extended(cx, scope, thisObj, length, compare, cmpBuf);
        } else {
            int i;
            int ilength = (int)length;
            Object[] working = new Object[ilength];
            for (i = 0; i != ilength; ++i) {
                working[i] = NativeArray.getElem(thisObj, i);
            }
            NativeArray.heapsort(cx, scope, working, ilength, compare, cmpBuf);
            for (i = 0; i != ilength; ++i) {
                NativeArray.setElem(thisObj, i, working[i]);
            }
        }
        return thisObj;
    }

    private static boolean isBigger(Context cx, Scriptable scope, Object x, Object y, Object cmp, Object[] cmpBuf) throws JavaScriptException {
        Scriptable undef;
        if (cmp == null) {
            if (cmpBuf != null) {
                Kit.codeBug();
            }
        } else if (cmpBuf == null || cmpBuf.length != 2) {
            Kit.codeBug();
        }
        if ((undef = Undefined.instance) == y) {
            return false;
        }
        if (undef == x) {
            return true;
        }
        if (cmp == null) {
            String b;
            String a = ScriptRuntime.toString(x);
            return a.compareTo(b = ScriptRuntime.toString(y)) > 0;
        }
        cmpBuf[0] = x;
        cmpBuf[1] = y;
        Object ret = ScriptRuntime.call(cx, cmp, null, cmpBuf, scope);
        double d = ScriptRuntime.toNumber(ret);
        return d > 0.0;
    }

    private static void heapsort(Context cx, Scriptable scope, Object[] array, int length, Object cmp, Object[] cmpBuf) throws JavaScriptException {
        Object pivot;
        if (length <= 1) {
            Kit.codeBug();
        }
        int i = length / 2;
        while (i != 0) {
            pivot = array[--i];
            NativeArray.heapify(cx, scope, pivot, array, i, length, cmp, cmpBuf);
        }
        i = length;
        while (i != 1) {
            pivot = array[--i];
            array[i] = array[0];
            NativeArray.heapify(cx, scope, pivot, array, 0, i, cmp, cmpBuf);
        }
    }

    private static void heapify(Context cx, Scriptable scope, Object pivot, Object[] array, int i, int end, Object cmp, Object[] cmpBuf) throws JavaScriptException {
        int child;
        while ((child = i * 2 + 1) < end) {
            Object nextVal;
            Object childVal = array[child];
            if (child + 1 < end && NativeArray.isBigger(cx, scope, nextVal = array[child + 1], childVal, cmp, cmpBuf)) {
                ++child;
                childVal = nextVal;
            }
            if (!NativeArray.isBigger(cx, scope, childVal, pivot, cmp, cmpBuf)) break;
            array[i] = childVal;
            i = child;
        }
        array[i] = pivot;
    }

    private static void heapsort_extended(Context cx, Scriptable scope, Scriptable target, long length, Object cmp, Object[] cmpBuf) throws JavaScriptException {
        Object pivot;
        if (length <= 1L) {
            Kit.codeBug();
        }
        long i = length / 2L;
        while (i != 0L) {
            pivot = NativeArray.getElem(target, --i);
            NativeArray.heapify_extended(cx, scope, pivot, target, i, length, cmp, cmpBuf);
        }
        i = length;
        while (i != 1L) {
            pivot = NativeArray.getElem(target, --i);
            NativeArray.setElem(target, i, NativeArray.getElem(target, 0L));
            NativeArray.heapify_extended(cx, scope, pivot, target, 0L, i, cmp, cmpBuf);
        }
    }

    private static void heapify_extended(Context cx, Scriptable scope, Object pivot, Scriptable target, long i, long end, Object cmp, Object[] cmpBuf) throws JavaScriptException {
        long child;
        while ((child = i * 2L + 1L) < end) {
            Object nextVal;
            Object childVal = NativeArray.getElem(target, child);
            if (child + 1L < end && NativeArray.isBigger(cx, scope, nextVal = NativeArray.getElem(target, child + 1L), childVal, cmp, cmpBuf)) {
                ++child;
                childVal = nextVal;
            }
            if (!NativeArray.isBigger(cx, scope, childVal, pivot, cmp, cmpBuf)) break;
            NativeArray.setElem(target, i, childVal);
            i = child;
        }
        NativeArray.setElem(target, i, pivot);
    }

    private static Object js_push(Context cx, Scriptable thisObj, Object[] args) {
        long length = NativeArray.getLengthProperty(thisObj);
        for (int i = 0; i < args.length; ++i) {
            NativeArray.setElem(thisObj, length + (long)i, args[i]);
        }
        Double lengthObj = new Double(length += (long)args.length);
        ScriptRuntime.setProp(thisObj, "length", lengthObj, thisObj);
        if (cx.getLanguageVersion() == 120) {
            return args.length == 0 ? Context.getUndefinedValue() : args[args.length - 1];
        }
        return lengthObj;
    }

    private static Object js_pop(Context cx, Scriptable thisObj, Object[] args) {
        long length = NativeArray.getLengthProperty(thisObj);
        Object result = length > 0L ? NativeArray.getElem(thisObj, --length) : Context.getUndefinedValue();
        ScriptRuntime.setProp(thisObj, "length", new Double(length), thisObj);
        return result;
    }

    private static Object js_shift(Context cx, Scriptable thisObj, Object[] args) {
        Object result;
        long length = NativeArray.getLengthProperty(thisObj);
        if (length > 0L) {
            long i = 0L;
            result = NativeArray.getElem(thisObj, i);
            if (--length > 0L) {
                for (i = 1L; i <= length; ++i) {
                    Object temp = NativeArray.getElem(thisObj, i);
                    NativeArray.setElem(thisObj, i - 1L, temp);
                }
            }
        } else {
            result = Context.getUndefinedValue();
        }
        ScriptRuntime.setProp(thisObj, "length", new Double(length), thisObj);
        return result;
    }

    private static Object js_unshift(Context cx, Scriptable thisObj, Object[] args) {
        double length = NativeArray.getLengthProperty(thisObj);
        int argc = args.length;
        if (args.length > 0) {
            if (length > 0.0) {
                for (long last = (long)length - 1L; last >= 0L; --last) {
                    Object temp = NativeArray.getElem(thisObj, last);
                    NativeArray.setElem(thisObj, last + (long)argc, temp);
                }
            }
            for (int i = 0; i < args.length; ++i) {
                NativeArray.setElem(thisObj, i, args[i]);
            }
            ScriptRuntime.setProp(thisObj, "length", new Double(length += (double)args.length), thisObj);
        }
        return new Long((long)length);
    }

    private static Object js_splice(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object temp;
        long count;
        scope = NativeArray.getTopLevelScope(scope);
        Object result = ScriptRuntime.newObject(cx, scope, "Array", null);
        int argc = args.length;
        if (argc == 0) {
            return result;
        }
        long length = NativeArray.getLengthProperty(thisObj);
        long begin = NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[0]), length);
        --argc;
        if (args.length == 1) {
            count = length - begin;
        } else {
            double dcount = ScriptRuntime.toInteger(args[1]);
            count = dcount < 0.0 ? 0L : (dcount > (double)(length - begin) ? length - begin : (long)dcount);
            --argc;
        }
        long end = begin + count;
        if (count != 0L) {
            if (count == 1L && cx.getLanguageVersion() == 120) {
                result = NativeArray.getElem(thisObj, begin);
            } else {
                for (long last = begin; last != end; ++last) {
                    Scriptable resultArray = (Scriptable)result;
                    Object temp2 = NativeArray.getElem(thisObj, last);
                    NativeArray.setElem(resultArray, last - begin, temp2);
                }
            }
        } else if (count == 0L && cx.getLanguageVersion() == 120) {
            result = Context.getUndefinedValue();
        }
        long delta = (long)argc - count;
        if (delta > 0L) {
            for (long last = length - 1L; last >= end; --last) {
                temp = NativeArray.getElem(thisObj, last);
                NativeArray.setElem(thisObj, last + delta, temp);
            }
        } else if (delta < 0L) {
            for (long last = end; last < length; ++last) {
                temp = NativeArray.getElem(thisObj, last);
                NativeArray.setElem(thisObj, last + delta, temp);
            }
        }
        int argoffset = args.length - argc;
        for (int i = 0; i < argc; ++i) {
            NativeArray.setElem(thisObj, begin + (long)i, args[i + argoffset]);
        }
        ScriptRuntime.setProp(thisObj, "length", new Double(length + delta), thisObj);
        return result;
    }

    private static Scriptable js_concat(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        long length;
        scope = NativeArray.getTopLevelScope(scope);
        Function ctor = ScriptRuntime.getExistingCtor(cx, scope, "Array");
        Scriptable result = ctor.construct(cx, scope, ScriptRuntime.emptyArgs);
        long slot = 0L;
        if (ScriptRuntime.instanceOf(thisObj, ctor, scope)) {
            length = NativeArray.getLengthProperty(thisObj);
            for (slot = 0L; slot < length; ++slot) {
                Object temp = NativeArray.getElem(thisObj, slot);
                NativeArray.setElem(result, slot, temp);
            }
        } else {
            NativeArray.setElem(result, slot++, thisObj);
        }
        for (int i = 0; i < args.length; ++i) {
            if (ScriptRuntime.instanceOf(args[i], ctor, scope)) {
                Scriptable arg = (Scriptable)args[i];
                length = NativeArray.getLengthProperty(arg);
                long j = 0L;
                while (j < length) {
                    Object temp = NativeArray.getElem(arg, j);
                    NativeArray.setElem(result, slot, temp);
                    ++j;
                    ++slot;
                }
                continue;
            }
            NativeArray.setElem(result, slot++, args[i]);
        }
        return result;
    }

    private Scriptable js_slice(Context cx, Scriptable thisObj, Object[] args) {
        long end;
        long begin;
        Scriptable scope = NativeArray.getTopLevelScope(this);
        Scriptable result = ScriptRuntime.newObject(cx, scope, "Array", null);
        long length = NativeArray.getLengthProperty(thisObj);
        if (args.length == 0) {
            begin = 0L;
            end = length;
        } else {
            begin = NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[0]), length);
            end = args.length == 1 ? length : NativeArray.toSliceIndex(ScriptRuntime.toInteger(args[1]), length);
        }
        for (long slot = begin; slot < end; ++slot) {
            Object temp = NativeArray.getElem(thisObj, slot);
            NativeArray.setElem(result, slot - begin, temp);
        }
        return result;
    }

    private static long toSliceIndex(double value, long length) {
        long result = value < 0.0 ? (value + (double)length < 0.0 ? 0L : (long)(value + (double)length)) : (value > (double)length ? length : (long)value);
        return result;
    }

    @Override
    protected String getIdName(int id) {
        if (id == 1) {
            return "length";
        }
        if (this.prototypeFlag) {
            switch (id) {
                case 2: {
                    return "constructor";
                }
                case 3: {
                    return "toString";
                }
                case 4: {
                    return "toLocaleString";
                }
                case 5: {
                    return "toSource";
                }
                case 6: {
                    return "join";
                }
                case 7: {
                    return "reverse";
                }
                case 8: {
                    return "sort";
                }
                case 9: {
                    return "push";
                }
                case 10: {
                    return "pop";
                }
                case 11: {
                    return "shift";
                }
                case 12: {
                    return "unshift";
                }
                case 13: {
                    return "splice";
                }
                case 14: {
                    return "concat";
                }
                case 15: {
                    return "slice";
                }
            }
        }
        return null;
    }

    @Override
    protected int mapNameToId(String s) {
        if (s.equals("length")) {
            return 1;
        }
        if (this.prototypeFlag) {
            return NativeArray.toPrototypeId(s);
        }
        return 0;
    }

    private static int toPrototypeId(String s) {
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 3: {
                X = "pop";
                id = 10;
                break;
            }
            case 4: {
                char c = s.charAt(0);
                if (c == 'j') {
                    X = "join";
                    id = 6;
                    break;
                }
                if (c == 'p') {
                    X = "push";
                    id = 9;
                    break;
                }
                if (c != 's') break;
                X = "sort";
                id = 8;
                break;
            }
            case 5: {
                char c = s.charAt(1);
                if (c == 'h') {
                    X = "shift";
                    id = 11;
                    break;
                }
                if (c != 'l') break;
                X = "slice";
                id = 15;
                break;
            }
            case 6: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "concat";
                    id = 14;
                    break;
                }
                if (c != 's') break;
                X = "splice";
                id = 13;
                break;
            }
            case 7: {
                char c = s.charAt(0);
                if (c == 'r') {
                    X = "reverse";
                    id = 7;
                    break;
                }
                if (c != 'u') break;
                X = "unshift";
                id = 12;
                break;
            }
            case 8: {
                char c = s.charAt(3);
                if (c == 'o') {
                    X = "toSource";
                    id = 5;
                    break;
                }
                if (c != 't') break;
                X = "toString";
                id = 3;
                break;
            }
            case 11: {
                X = "constructor";
                id = 2;
                break;
            }
            case 14: {
                X = "toLocaleString";
                id = 4;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

