/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.percentages.fonts;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public class FontSizeAdjustResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE, FontStyleKeys.FONT_FAMILY, FontStyleKeys.FONT_EFFECT, FontStyleKeys.FONT_SMOOTH, FontStyleKeys.FONT_STRETCH, FontStyleKeys.FONT_VARIANT, FontStyleKeys.FONT_WEIGHT};
    }

    @Override
    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (!(cSSValue instanceof CSSNumericValue)) {
            return;
        }
        CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
        if (!CSSNumericType.NUMBER.equals(cSSNumericValue.getType())) {
            return;
        }
        LayoutElement layoutElement2 = layoutElement.getParent();
        if (layoutElement2 == null) {
            return;
        }
        double d = cSSNumericValue.getValue();
        FontSpecification fontSpecification = layoutElement.getLayoutContext().getFontSpecification();
        FontMetrics fontMetrics = layoutProcess.getOutputMetaData().getFontMetrics(fontSpecification);
        if (fontMetrics == null) {
            return;
        }
        double d2 = StrictGeomUtility.toExternalValue(fontMetrics.getXHeight());
        double d3 = fontSpecification.getFontSize();
        double d4 = d2 / d3;
        double d5 = d3 * (d / d4);
        fontSpecification.setFontSize(d5);
    }
}

